% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{billingconductor}
\alias{billingconductor}
\title{AWSBillingConductor}
\usage{
billingconductor(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Web Services Billing Conductor is a fully managed service that
you can use to customize a
\href{https://docs.aws.amazon.com/billingconductor/latest/userguide/#eb-other-definitions}{proforma}
version of your billing data each month, to accurately show or
chargeback your end customers. Amazon Web Services Billing Conductor
doesn't change the way you're billed by Amazon Web Services each month
by design. Instead, it provides you with a mechanism to configure,
generate, and display rates to certain customers over a given billing
period. You can also analyze the difference between the rates you apply
to your accounting groupings relative to your actual rates from Amazon
Web Services. As a result of your Amazon Web Services Billing Conductor
configuration, the payer account can also see the custom rate applied on
the billing details page of the Amazon Web Services Billing console, or
configure a cost and usage report per billing group.

This documentation shows how you can configure Amazon Web Services
Billing Conductor using its API. For more information about using the
Amazon Web Services Billing Conductor user interface, see the \href{https://docs.aws.amazon.com/billingconductor/latest/userguide/what-is-billingconductor.html}{Amazon Web Services Billing Conductor User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- billingconductor(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.cost.management:billingconductor_associate_accounts]{associate_accounts} \tab Connects an array of account IDs in a consolidated billing family to a predefined billing group\cr
\link[paws.cost.management:billingconductor_associate_pricing_rules]{associate_pricing_rules} \tab Connects an array of PricingRuleArns to a defined PricingPlan\cr
\link[paws.cost.management:billingconductor_batch_associate_resources_to_custom_line_item]{batch_associate_resources_to_custom_line_item} \tab Associates a batch of resources to a percentage custom line item\cr
\link[paws.cost.management:billingconductor_batch_disassociate_resources_from_custom_line_item]{batch_disassociate_resources_from_custom_line_item} \tab Disassociates a batch of resources from a percentage custom line item\cr
\link[paws.cost.management:billingconductor_create_billing_group]{create_billing_group} \tab Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off of the predefined pricing plan computation\cr
\link[paws.cost.management:billingconductor_create_custom_line_item]{create_custom_line_item} \tab Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single billing group for the current or previous billing period\cr
\link[paws.cost.management:billingconductor_create_pricing_plan]{create_pricing_plan} \tab Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups\cr
\link[paws.cost.management:billingconductor_create_pricing_rule]{create_pricing_rule} \tab Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans\cr
\link[paws.cost.management:billingconductor_delete_billing_group]{delete_billing_group} \tab Deletes a billing group\cr
\link[paws.cost.management:billingconductor_delete_custom_line_item]{delete_custom_line_item} \tab Deletes the custom line item identified by the given ARN in the current, or previous billing period\cr
\link[paws.cost.management:billingconductor_delete_pricing_plan]{delete_pricing_plan} \tab Deletes a pricing plan\cr
\link[paws.cost.management:billingconductor_delete_pricing_rule]{delete_pricing_rule} \tab Deletes the pricing rule that's identified by the input Amazon Resource Name (ARN)\cr
\link[paws.cost.management:billingconductor_disassociate_accounts]{disassociate_accounts} \tab Removes the specified list of account IDs from the given billing group\cr
\link[paws.cost.management:billingconductor_disassociate_pricing_rules]{disassociate_pricing_rules} \tab Disassociates a list of pricing rules from a pricing plan\cr
\link[paws.cost.management:billingconductor_get_billing_group_cost_report]{get_billing_group_cost_report} \tab Retrieves the margin summary report, which includes the Amazon Web Services cost and charged amount (pro forma cost) by Amazon Web Service for a specific billing group\cr
\link[paws.cost.management:billingconductor_list_account_associations]{list_account_associations} \tab This is a paginated call to list linked accounts that are linked to the payer account for the specified time period\cr
\link[paws.cost.management:billingconductor_list_billing_group_cost_reports]{list_billing_group_cost_reports} \tab A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web Services charges based on the associated pricing plan of a billing group\cr
\link[paws.cost.management:billingconductor_list_billing_groups]{list_billing_groups} \tab A paginated call to retrieve a list of billing groups for the given billing period\cr
\link[paws.cost.management:billingconductor_list_custom_line_items]{list_custom_line_items} \tab A paginated call to get a list of all custom line items (FFLIs) for the given billing period\cr
\link[paws.cost.management:billingconductor_list_custom_line_item_versions]{list_custom_line_item_versions} \tab A paginated call to get a list of all custom line item versions\cr
\link[paws.cost.management:billingconductor_list_pricing_plans]{list_pricing_plans} \tab A paginated call to get pricing plans for the given billing period\cr
\link[paws.cost.management:billingconductor_list_pricing_plans_associated_with_pricing_rule]{list_pricing_plans_associated_with_pricing_rule} \tab A list of the pricing plans that are associated with a pricing rule\cr
\link[paws.cost.management:billingconductor_list_pricing_rules]{list_pricing_rules} \tab Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans\cr
\link[paws.cost.management:billingconductor_list_pricing_rules_associated_to_pricing_plan]{list_pricing_rules_associated_to_pricing_plan} \tab Lists the pricing rules that are associated with a pricing plan\cr
\link[paws.cost.management:billingconductor_list_resources_associated_to_custom_line_item]{list_resources_associated_to_custom_line_item} \tab List the resources that are associated to a custom line item\cr
\link[paws.cost.management:billingconductor_list_tags_for_resource]{list_tags_for_resource} \tab A list the tags for a resource\cr
\link[paws.cost.management:billingconductor_tag_resource]{tag_resource} \tab Associates the specified tags to a resource with the specified resourceArn\cr
\link[paws.cost.management:billingconductor_untag_resource]{untag_resource} \tab Deletes specified tags from a resource\cr
\link[paws.cost.management:billingconductor_update_billing_group]{update_billing_group} \tab This updates an existing billing group\cr
\link[paws.cost.management:billingconductor_update_custom_line_item]{update_custom_line_item} \tab Update an existing custom line item in the current or previous billing period\cr
\link[paws.cost.management:billingconductor_update_pricing_plan]{update_pricing_plan} \tab This updates an existing pricing plan\cr
\link[paws.cost.management:billingconductor_update_pricing_rule]{update_pricing_rule} \tab Updates an existing pricing rule
}
}

\examples{
\dontrun{
svc <- billingconductor()
svc$associate_accounts(
  Foo = 123
)
}

}
