% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_svd.r
\docType{methods}
\name{ddmatrix-svd}
\alias{La.svd}
\alias{La.svd,ANY-method}
\alias{La.svd,ddmatrix-method}
\alias{ddmatrix-svd}
\alias{svd}
\alias{svd,ANY-method}
\alias{svd,ddmatrix-method}
\title{Singular Value Decomposition}
\usage{
\S4method{La.svd}{ANY}(x, nu = min(n, p), nv = min(n, p))

\S4method{La.svd}{ddmatrix}(x, nu = min(n, p), nv = min(n, p))

\S4method{svd}{ANY}(x, nu = min(n, p), nv = min(n, p), LINPACK = FALSE)

\S4method{svd}{ddmatrix}(x, nu = min(n, p), nv = min(n, p))
}
\arguments{
\item{x}{numeric distributed matrices.}

\item{nu}{number of left singular vectors to return when calculating
singular values.}

\item{nv}{number of right singular vectors to return when calculating
singular values.}

\item{LINPACK}{Ignored.}
}
\value{
\code{La.svd()} performs singular value decomposition, and returns the
transpose of right singular vectors if any are requested. Singular values
are stored as a global R vector. Left and right singular vectors are unique
up to sign. Sometimes core R (via LAPACK) and ScaLAPACK will disagree as to
what the left/right singular vectors are, but the disagreement is always
only up to sign.

\code{svd()} performs singular value decomposition. Differs from
\code{La.svd()} in that the right singular vectors, if requested, are
returned non-transposed. Singular values are stored as a global R vector.
Sometimes core R (via LAPACK) and ScaLAPACK will disagree as to what the
left/right singular vectors are, but the disagreement is always only up to
sign.
}
\description{
SVD for distributed matrices with R-like syntax, with
calculations performed by the PBLAS and ScaLAPACK libraries.
}
\details{
Extensions of R linear algebra functions.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

# don't do this in production code
x <- matrix(1:9, 3)
x <- as.ddmatrix(x)

y <- svd(A)
print(y)

finalize()
}

}

