// Generated by rstantools.  Do not edit by hand.

/*
    pcFactorStan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pcFactorStan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pcFactorStan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_unidim_ll_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_unidim_ll");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_unidim_ll");
    reader.add_event(15, 2, "include", "/functions/pairwise.stan");
    reader.add_event(15, 0, "start", "/functions/pairwise.stan");
    reader.add_event(94, 79, "end", "/functions/pairwise.stan");
    reader.add_event(94, 3, "restart", "model_unidim_ll");
    reader.add_event(169, 76, "end", "model_unidim_ll");
    return reader;
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
cmp_probs(const T0__& scale,
              const T1__& alpha,
              const T2__& pa1,
              const T3__& pa2,
              const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& thr,
              const std::vector<int>& want, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 17;
        int nth(0);
        (void) nth;  // dummy to suppress unused var warning
        stan::math::fill(nth, std::numeric_limits<int>::min());
        stan::math::assign(nth,num_elements(thr));
        current_statement_begin__ = 18;
        int nth2(0);
        (void) nth2;  // dummy to suppress unused var warning
        stan::math::fill(nth2, std::numeric_limits<int>::min());
        stan::math::assign(nth2,(nth * 2));
        current_statement_begin__ = 19;
        validate_non_negative_index("pr", "(1 + nth2)", (1 + nth2));
        std::vector<local_scalar_t__  > pr((1 + nth2), local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(pr, DUMMY_VAR__);
        stan::math::fill(pr, DUMMY_VAR__);
        current_statement_begin__ = 20;
        validate_non_negative_index("out", "(1 + nth2)", (1 + nth2));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> out((1 + nth2));
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        current_statement_begin__ = 21;
        local_scalar_t__ paDiff(DUMMY_VAR__);
        (void) paDiff;  // dummy to suppress unused var warning
        stan::math::initialize(paDiff, DUMMY_VAR__);
        stan::math::fill(paDiff, DUMMY_VAR__);
        stan::math::assign(paDiff,((alpha * scale) * (pa1 - pa2)));
        current_statement_begin__ = 22;
        validate_non_negative_index("thrAlpha", "nth", nth);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> thrAlpha(nth);
        stan::math::initialize(thrAlpha, DUMMY_VAR__);
        stan::math::fill(thrAlpha, DUMMY_VAR__);
        stan::math::assign(thrAlpha,multiply(thr, alpha));
        current_statement_begin__ = 23;
        stan::model::assign(pr, 
                    stan::model::cons_list(stan::model::index_uni((1 + nth2)), stan::model::nil_index_list()), 
                    1, 
                    "assigning variable pr");
        current_statement_begin__ = 24;
        for (int tx = 1; tx <= nth2; ++tx) {
            current_statement_begin__ = 25;
            if (as_bool((primitive_value(get_base1(want, tx, "want", 1)) || primitive_value(get_base1(want, (tx + 1), "want", 1))))) {
                {
                current_statement_begin__ = 26;
                local_scalar_t__ at(DUMMY_VAR__);
                (void) at;  // dummy to suppress unused var warning
                stan::math::initialize(at, DUMMY_VAR__);
                stan::math::fill(at, DUMMY_VAR__);
                current_statement_begin__ = 27;
                if (as_bool(logical_lte(tx, nth))) {
                    current_statement_begin__ = 28;
                    stan::math::assign(at, -(get_base1(thrAlpha, ((nth + 1) - tx), "thrAlpha", 1)));
                } else {
                    current_statement_begin__ = 30;
                    stan::math::assign(at, get_base1(thrAlpha, (tx - nth), "thrAlpha", 1));
                }
                current_statement_begin__ = 32;
                stan::model::assign(pr, 
                            stan::model::cons_list(stan::model::index_uni(tx), stan::model::nil_index_list()), 
                            (1.0 / (1.0 + stan::math::exp(-((paDiff + at))))), 
                            "assigning variable pr");
                }
            } else {
                current_statement_begin__ = 34;
                stan::model::assign(pr, 
                            stan::model::cons_list(stan::model::index_uni(tx), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable pr");
            }
        }
        current_statement_begin__ = 37;
        stan::model::assign(out, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    get_base1(pr, 1, "pr", 1), 
                    "assigning variable out");
        current_statement_begin__ = 38;
        for (int tx = 2; tx <= num_elements(out); ++tx) {
            current_statement_begin__ = 39;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(tx), stan::model::nil_index_list()), 
                        (get_base1(pr, tx, "pr", 1) - get_base1(pr, (tx - 1), "pr", 1)), 
                        "assigning variable out");
        }
        current_statement_begin__ = 41;
        for (int tx = 1; tx <= num_elements(want); ++tx) {
            current_statement_begin__ = 42;
            if (as_bool((primitive_value(get_base1(want, tx, "want", 1)) && primitive_value((primitive_value(logical_lte(get_base1(out, tx, "out", 1), 0)) || primitive_value(logical_gte(get_base1(out, tx, "out", 1), 1))))))) {
                current_statement_begin__ = 43;
                std::stringstream errmsg_stream__;
                errmsg_stream__ << "out[";
                errmsg_stream__ << tx;
                errmsg_stream__ << "]=";
                errmsg_stream__ << get_base1(out, tx, "out", 1);
                errmsg_stream__ << "; scale=";
                errmsg_stream__ << scale;
                errmsg_stream__ << " alpha=";
                errmsg_stream__ << alpha;
                errmsg_stream__ << " pa1=";
                errmsg_stream__ << pa1;
                errmsg_stream__ << " pa2=";
                errmsg_stream__ << pa2;
                errmsg_stream__ << " th=";
                errmsg_stream__ << thr;
                throw std::domain_error(errmsg_stream__.str());
            }
        }
        current_statement_begin__ = 47;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct cmp_probs_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
    operator()(const T0__& scale,
              const T1__& alpha,
              const T2__& pa1,
              const T3__& pa2,
              const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& thr,
              const std::vector<int>& want, std::ostream* pstream__) const {
        return cmp_probs(scale, alpha, pa1, pa2, thr, want, pstream__);
    }
};
template <typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__>::type>::type
pairwise_logprob(const std::vector<int>& rcat,
                     const std::vector<int>& weight,
                     const int& cmpStart,
                     const int& len,
                     const T4__& scale,
                     const T5__& alpha,
                     const T6__& pa1,
                     const T7__& pa2,
                     const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& cumTh, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 53;
        local_scalar_t__ lp(DUMMY_VAR__);
        (void) lp;  // dummy to suppress unused var warning
        stan::math::initialize(lp, DUMMY_VAR__);
        stan::math::fill(lp, DUMMY_VAR__);
        stan::math::assign(lp,0);
        current_statement_begin__ = 54;
        int nth(0);
        (void) nth;  // dummy to suppress unused var warning
        stan::math::fill(nth, std::numeric_limits<int>::min());
        stan::math::assign(nth,num_elements(cumTh));
        current_statement_begin__ = 55;
        validate_non_negative_index("prob", "(1 + (nth * 2))", (1 + (nth * 2)));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> prob((1 + (nth * 2)));
        stan::math::initialize(prob, DUMMY_VAR__);
        stan::math::fill(prob, DUMMY_VAR__);
        current_statement_begin__ = 56;
        validate_non_negative_index("want", "(1 + (nth * 2))", (1 + (nth * 2)));
        std::vector<int  > want((1 + (nth * 2)), int(0));
        stan::math::fill(want, std::numeric_limits<int>::min());
        current_statement_begin__ = 57;
        for (int ox = 1; ox <= num_elements(want); ++ox) {
            current_statement_begin__ = 57;
            stan::model::assign(want, 
                        stan::model::cons_list(stan::model::index_uni(ox), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable want");
        }
        current_statement_begin__ = 58;
        for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
            current_statement_begin__ = 59;
            stan::model::assign(want, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(rcat, ox, "rcat", 1)), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable want");
        }
        current_statement_begin__ = 61;
        stan::math::assign(prob, cmp_probs(scale, alpha, pa1, pa2, cumTh, want, pstream__));
        current_statement_begin__ = 62;
        for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
            {
            current_statement_begin__ = 63;
            local_scalar_t__ lp1(DUMMY_VAR__);
            (void) lp1;  // dummy to suppress unused var warning
            stan::math::initialize(lp1, DUMMY_VAR__);
            stan::math::fill(lp1, DUMMY_VAR__);
            stan::math::assign(lp1,stan::math::log(get_base1(prob, get_base1(rcat, ox, "rcat", 1), "prob", 1)));
            current_statement_begin__ = 64;
            if (as_bool(logical_eq(get_base1(weight, ox, "weight", 1), 1))) {
                current_statement_begin__ = 65;
                stan::math::assign(lp, (lp + lp1));
            } else {
                current_statement_begin__ = 67;
                stan::math::assign(lp, (lp + (get_base1(weight, ox, "weight", 1) * lp1)));
            }
            }
        }
        current_statement_begin__ = 70;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lp);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct pairwise_logprob_functor__ {
    template <typename T4__, typename T5__, typename T6__, typename T7__, typename T8__>
        typename boost::math::tools::promote_args<T4__, T5__, T6__, T7__, typename boost::math::tools::promote_args<T8__>::type>::type
    operator()(const std::vector<int>& rcat,
                     const std::vector<int>& weight,
                     const int& cmpStart,
                     const int& len,
                     const T4__& scale,
                     const T5__& alpha,
                     const T6__& pa1,
                     const T7__& pa2,
                     const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& cumTh, std::ostream* pstream__) const {
        return pairwise_logprob(rcat, weight, cmpStart, len, scale, alpha, pa1, pa2, cumTh, pstream__);
    }
};
template <typename T5__, typename T6__, typename T7__, typename T8__, typename T9__>
std::vector<typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type>
pairwise_loo(const std::vector<int>& rcat,
                 const std::vector<int>& weight,
                 const int& numOutcome,
                 const int& cmpStart,
                 const int& len,
                 const T5__& scale,
                 const T6__& alpha,
                 const T7__& pa1,
                 const T8__& pa2,
                 const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& cumTh, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 76;
        validate_non_negative_index("lp", "numOutcome", numOutcome);
        std::vector<local_scalar_t__  > lp(numOutcome, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(lp, DUMMY_VAR__);
        stan::math::fill(lp, DUMMY_VAR__);
        current_statement_begin__ = 77;
        int cur(0);
        (void) cur;  // dummy to suppress unused var warning
        stan::math::fill(cur, std::numeric_limits<int>::min());
        stan::math::assign(cur,1);
        current_statement_begin__ = 78;
        int nth(0);
        (void) nth;  // dummy to suppress unused var warning
        stan::math::fill(nth, std::numeric_limits<int>::min());
        stan::math::assign(nth,num_elements(cumTh));
        current_statement_begin__ = 79;
        validate_non_negative_index("prob", "(1 + (nth * 2))", (1 + (nth * 2)));
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> prob((1 + (nth * 2)));
        stan::math::initialize(prob, DUMMY_VAR__);
        stan::math::fill(prob, DUMMY_VAR__);
        current_statement_begin__ = 80;
        validate_non_negative_index("want", "(1 + (nth * 2))", (1 + (nth * 2)));
        std::vector<int  > want((1 + (nth * 2)), int(0));
        stan::math::fill(want, std::numeric_limits<int>::min());
        current_statement_begin__ = 81;
        for (int ox = 1; ox <= num_elements(want); ++ox) {
            current_statement_begin__ = 81;
            stan::model::assign(want, 
                        stan::model::cons_list(stan::model::index_uni(ox), stan::model::nil_index_list()), 
                        0, 
                        "assigning variable want");
        }
        current_statement_begin__ = 82;
        for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
            current_statement_begin__ = 83;
            stan::model::assign(want, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(rcat, ox, "rcat", 1)), stan::model::nil_index_list()), 
                        1, 
                        "assigning variable want");
        }
        current_statement_begin__ = 85;
        stan::math::assign(prob, cmp_probs(scale, alpha, pa1, pa2, cumTh, want, pstream__));
        current_statement_begin__ = 86;
        for (int ox = cmpStart; ox <= ((cmpStart + len) - 1); ++ox) {
            {
            current_statement_begin__ = 87;
            local_scalar_t__ lp1(DUMMY_VAR__);
            (void) lp1;  // dummy to suppress unused var warning
            stan::math::initialize(lp1, DUMMY_VAR__);
            stan::math::fill(lp1, DUMMY_VAR__);
            stan::math::assign(lp1,stan::math::log(get_base1(prob, get_base1(rcat, ox, "rcat", 1), "prob", 1)));
            current_statement_begin__ = 88;
            for (int wx = 1; wx <= get_base1(weight, ox, "weight", 1); ++wx) {
                current_statement_begin__ = 89;
                stan::model::assign(lp, 
                            stan::model::cons_list(stan::model::index_uni(cur), stan::model::nil_index_list()), 
                            lp1, 
                            "assigning variable lp");
                current_statement_begin__ = 90;
                stan::math::assign(cur, (cur + 1));
            }
            }
        }
        current_statement_begin__ = 93;
        return stan::math::promote_scalar<fun_return_scalar_t__>(lp);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct pairwise_loo_functor__ {
    template <typename T5__, typename T6__, typename T7__, typename T8__, typename T9__>
        std::vector<typename boost::math::tools::promote_args<T5__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type>
    operator()(const std::vector<int>& rcat,
                 const std::vector<int>& weight,
                 const int& numOutcome,
                 const int& cmpStart,
                 const int& len,
                 const T5__& scale,
                 const T6__& alpha,
                 const T7__& pa1,
                 const T8__& pa2,
                 const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& cumTh, std::ostream* pstream__) const {
        return pairwise_loo(rcat, weight, numOutcome, cmpStart, len, scale, alpha, pa1, pa2, cumTh, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_unidim_ll
  : public stan::model::model_base_crtp<model_unidim_ll> {
private:
        double alphaScalePrior;
        int NPA;
        int NCMP;
        int N;
        int numRefresh;
        int NTHRESH;
        double scale;
        std::vector<int> pa1;
        std::vector<int> pa2;
        std::vector<int> weight;
        std::vector<int> pick;
        std::vector<int> refresh;
        std::vector<int> numOutcome;
        std::vector<int> rcat;
public:
    model_unidim_ll(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_unidim_ll(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_unidim_ll_namespace::model_unidim_ll";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 97;
            context__.validate_dims("data initialization", "alphaScalePrior", "double", context__.to_vec());
            alphaScalePrior = double(0);
            vals_r__ = context__.vals_r("alphaScalePrior");
            pos__ = 0;
            alphaScalePrior = vals_r__[pos__++];
            current_statement_begin__ = 99;
            context__.validate_dims("data initialization", "NPA", "int", context__.to_vec());
            NPA = int(0);
            vals_i__ = context__.vals_i("NPA");
            pos__ = 0;
            NPA = vals_i__[pos__++];
            check_greater_or_equal(function__, "NPA", NPA, 1);
            current_statement_begin__ = 100;
            context__.validate_dims("data initialization", "NCMP", "int", context__.to_vec());
            NCMP = int(0);
            vals_i__ = context__.vals_i("NCMP");
            pos__ = 0;
            NCMP = vals_i__[pos__++];
            check_greater_or_equal(function__, "NCMP", NCMP, 1);
            current_statement_begin__ = 101;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 102;
            context__.validate_dims("data initialization", "numRefresh", "int", context__.to_vec());
            numRefresh = int(0);
            vals_i__ = context__.vals_i("numRefresh");
            pos__ = 0;
            numRefresh = vals_i__[pos__++];
            check_greater_or_equal(function__, "numRefresh", numRefresh, 1);
            current_statement_begin__ = 103;
            context__.validate_dims("data initialization", "NTHRESH", "int", context__.to_vec());
            NTHRESH = int(0);
            vals_i__ = context__.vals_i("NTHRESH");
            pos__ = 0;
            NTHRESH = vals_i__[pos__++];
            check_greater_or_equal(function__, "NTHRESH", NTHRESH, 1);
            current_statement_begin__ = 104;
            context__.validate_dims("data initialization", "scale", "double", context__.to_vec());
            scale = double(0);
            vals_r__ = context__.vals_r("scale");
            pos__ = 0;
            scale = vals_r__[pos__++];
            current_statement_begin__ = 106;
            validate_non_negative_index("pa1", "numRefresh", numRefresh);
            context__.validate_dims("data initialization", "pa1", "int", context__.to_vec(numRefresh));
            pa1 = std::vector<int>(numRefresh, int(0));
            vals_i__ = context__.vals_i("pa1");
            pos__ = 0;
            size_t pa1_k_0_max__ = numRefresh;
            for (size_t k_0__ = 0; k_0__ < pa1_k_0_max__; ++k_0__) {
                pa1[k_0__] = vals_i__[pos__++];
            }
            size_t pa1_i_0_max__ = numRefresh;
            for (size_t i_0__ = 0; i_0__ < pa1_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pa1[i_0__]", pa1[i_0__], 1);
                check_less_or_equal(function__, "pa1[i_0__]", pa1[i_0__], NPA);
            }
            current_statement_begin__ = 107;
            validate_non_negative_index("pa2", "numRefresh", numRefresh);
            context__.validate_dims("data initialization", "pa2", "int", context__.to_vec(numRefresh));
            pa2 = std::vector<int>(numRefresh, int(0));
            vals_i__ = context__.vals_i("pa2");
            pos__ = 0;
            size_t pa2_k_0_max__ = numRefresh;
            for (size_t k_0__ = 0; k_0__ < pa2_k_0_max__; ++k_0__) {
                pa2[k_0__] = vals_i__[pos__++];
            }
            size_t pa2_i_0_max__ = numRefresh;
            for (size_t i_0__ = 0; i_0__ < pa2_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pa2[i_0__]", pa2[i_0__], 1);
                check_less_or_equal(function__, "pa2[i_0__]", pa2[i_0__], NPA);
            }
            current_statement_begin__ = 108;
            validate_non_negative_index("weight", "NCMP", NCMP);
            context__.validate_dims("data initialization", "weight", "int", context__.to_vec(NCMP));
            weight = std::vector<int>(NCMP, int(0));
            vals_i__ = context__.vals_i("weight");
            pos__ = 0;
            size_t weight_k_0_max__ = NCMP;
            for (size_t k_0__ = 0; k_0__ < weight_k_0_max__; ++k_0__) {
                weight[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 109;
            validate_non_negative_index("pick", "NCMP", NCMP);
            context__.validate_dims("data initialization", "pick", "int", context__.to_vec(NCMP));
            pick = std::vector<int>(NCMP, int(0));
            vals_i__ = context__.vals_i("pick");
            pos__ = 0;
            size_t pick_k_0_max__ = NCMP;
            for (size_t k_0__ = 0; k_0__ < pick_k_0_max__; ++k_0__) {
                pick[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 110;
            validate_non_negative_index("refresh", "numRefresh", numRefresh);
            context__.validate_dims("data initialization", "refresh", "int", context__.to_vec(numRefresh));
            refresh = std::vector<int>(numRefresh, int(0));
            vals_i__ = context__.vals_i("refresh");
            pos__ = 0;
            size_t refresh_k_0_max__ = numRefresh;
            for (size_t k_0__ = 0; k_0__ < refresh_k_0_max__; ++k_0__) {
                refresh[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 111;
            validate_non_negative_index("numOutcome", "numRefresh", numRefresh);
            context__.validate_dims("data initialization", "numOutcome", "int", context__.to_vec(numRefresh));
            numOutcome = std::vector<int>(numRefresh, int(0));
            vals_i__ = context__.vals_i("numOutcome");
            pos__ = 0;
            size_t numOutcome_k_0_max__ = numRefresh;
            for (size_t k_0__ = 0; k_0__ < numOutcome_k_0_max__; ++k_0__) {
                numOutcome[k_0__] = vals_i__[pos__++];
            }
            // initialize transformed data variables
            current_statement_begin__ = 114;
            validate_non_negative_index("rcat", "NCMP", NCMP);
            rcat = std::vector<int>(NCMP, int(0));
            stan::math::fill(rcat, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 116;
            for (int cmp = 1; cmp <= NCMP; ++cmp) {
                current_statement_begin__ = 117;
                stan::model::assign(rcat, 
                            stan::model::cons_list(stan::model::index_uni(cmp), stan::model::nil_index_list()), 
                            ((get_base1(pick, cmp, "pick", 1) + NTHRESH) + 1), 
                            "assigning variable rcat");
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 121;
            validate_non_negative_index("rawTheta", "NPA", NPA);
            num_params_r__ += NPA;
            current_statement_begin__ = 122;
            validate_non_negative_index("rawThreshold", "NTHRESH", NTHRESH);
            num_params_r__ += NTHRESH;
            current_statement_begin__ = 123;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_unidim_ll() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 121;
        if (!(context__.contains_r("rawTheta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawTheta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawTheta");
        pos__ = 0U;
        validate_non_negative_index("rawTheta", "NPA", NPA);
        context__.validate_dims("parameter initialization", "rawTheta", "vector_d", context__.to_vec(NPA));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawTheta(NPA);
        size_t rawTheta_j_1_max__ = NPA;
        for (size_t j_1__ = 0; j_1__ < rawTheta_j_1_max__; ++j_1__) {
            rawTheta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(rawTheta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawTheta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 122;
        if (!(context__.contains_r("rawThreshold")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rawThreshold missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rawThreshold");
        pos__ = 0U;
        validate_non_negative_index("rawThreshold", "NTHRESH", NTHRESH);
        context__.validate_dims("parameter initialization", "rawThreshold", "vector_d", context__.to_vec(NTHRESH));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawThreshold(NTHRESH);
        size_t rawThreshold_j_1_max__ = NTHRESH;
        for (size_t j_1__ = 0; j_1__ < rawThreshold_j_1_max__; ++j_1__) {
            rawThreshold(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, rawThreshold);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rawThreshold: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 123;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 121;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawTheta;
            (void) rawTheta;  // dummy to suppress unused var warning
            if (jacobian__)
                rawTheta = in__.vector_constrain(NPA, lp__);
            else
                rawTheta = in__.vector_constrain(NPA);
            current_statement_begin__ = 122;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawThreshold;
            (void) rawThreshold;  // dummy to suppress unused var warning
            if (jacobian__)
                rawThreshold = in__.vector_lub_constrain(0, 1, NTHRESH, lp__);
            else
                rawThreshold = in__.vector_lub_constrain(0, 1, NTHRESH);
            current_statement_begin__ = 123;
            local_scalar_t__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_lb_constrain(0, lp__);
            else
                alpha = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 126;
            validate_non_negative_index("threshold", "NTHRESH", NTHRESH);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> threshold(NTHRESH);
            stan::math::initialize(threshold, DUMMY_VAR__);
            stan::math::fill(threshold, DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("rawCumTh", "NTHRESH", NTHRESH);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rawCumTh(NTHRESH);
            stan::math::initialize(rawCumTh, DUMMY_VAR__);
            stan::math::fill(rawCumTh, DUMMY_VAR__);
            current_statement_begin__ = 128;
            local_scalar_t__ maxSpan;
            (void) maxSpan;  // dummy to suppress unused var warning
            stan::math::initialize(maxSpan, DUMMY_VAR__);
            stan::math::fill(maxSpan, DUMMY_VAR__);
            stan::math::assign(maxSpan,(max(rawTheta) - min(rawTheta)));
            // transformed parameters block statements
            current_statement_begin__ = 129;
            stan::math::assign(threshold, multiply(maxSpan, rawThreshold));
            current_statement_begin__ = 130;
            stan::math::assign(rawCumTh, cumulative_sum(threshold));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 126;
            size_t threshold_j_1_max__ = NTHRESH;
            for (size_t j_1__ = 0; j_1__ < threshold_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(threshold(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: threshold" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable threshold: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 127;
            size_t rawCumTh_j_1_max__ = NTHRESH;
            for (size_t j_1__ = 0; j_1__ < rawCumTh_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(rawCumTh(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: rawCumTh" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rawCumTh: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 128;
            if (stan::math::is_uninitialized(maxSpan)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: maxSpan";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable maxSpan: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            // model body
            current_statement_begin__ = 134;
            lp_accum__.add(normal_log<propto__>(alpha, 1.749, alphaScalePrior));
            if (alpha < 0) lp_accum__.add(-std::numeric_limits<double>::infinity());
            else lp_accum__.add(-normal_ccdf_log(0, 1.749, alphaScalePrior));
            current_statement_begin__ = 135;
            lp_accum__.add(std_normal_log<propto__>(rawTheta));
            current_statement_begin__ = 136;
            lp_accum__.add(beta_log<propto__>(rawThreshold, 1.1, 2));
            {
            current_statement_begin__ = 139;
            int cmpStart(0);
            (void) cmpStart;  // dummy to suppress unused var warning
            stan::math::fill(cmpStart, std::numeric_limits<int>::min());
            stan::math::assign(cmpStart,1);
            current_statement_begin__ = 140;
            for (int rx = 1; rx <= numRefresh; ++rx) {
                current_statement_begin__ = 141;
                lp_accum__.add(pairwise_logprob(rcat, weight, cmpStart, get_base1(refresh, rx, "refresh", 1), scale, alpha, get_base1(rawTheta, get_base1(pa1, rx, "pa1", 1), "rawTheta", 1), get_base1(rawTheta, get_base1(pa2, rx, "pa2", 1), "rawTheta", 1), rawCumTh, pstream__));
                current_statement_begin__ = 143;
                stan::math::assign(cmpStart, (cmpStart + get_base1(refresh, rx, "refresh", 1)));
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("rawTheta");
        names__.push_back("rawThreshold");
        names__.push_back("alpha");
        names__.push_back("threshold");
        names__.push_back("rawCumTh");
        names__.push_back("maxSpan");
        names__.push_back("log_lik");
        names__.push_back("theta");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(NPA);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NTHRESH);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NTHRESH);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NTHRESH);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NPA);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_unidim_ll_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawTheta = in__.vector_constrain(NPA);
        size_t rawTheta_j_1_max__ = NPA;
        for (size_t j_1__ = 0; j_1__ < rawTheta_j_1_max__; ++j_1__) {
            vars__.push_back(rawTheta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rawThreshold = in__.vector_lub_constrain(0, 1, NTHRESH);
        size_t rawThreshold_j_1_max__ = NTHRESH;
        for (size_t j_1__ = 0; j_1__ < rawThreshold_j_1_max__; ++j_1__) {
            vars__.push_back(rawThreshold(j_1__));
        }
        double alpha = in__.scalar_lb_constrain(0);
        vars__.push_back(alpha);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 126;
            validate_non_negative_index("threshold", "NTHRESH", NTHRESH);
            Eigen::Matrix<double, Eigen::Dynamic, 1> threshold(NTHRESH);
            stan::math::initialize(threshold, DUMMY_VAR__);
            stan::math::fill(threshold, DUMMY_VAR__);
            current_statement_begin__ = 127;
            validate_non_negative_index("rawCumTh", "NTHRESH", NTHRESH);
            Eigen::Matrix<double, Eigen::Dynamic, 1> rawCumTh(NTHRESH);
            stan::math::initialize(rawCumTh, DUMMY_VAR__);
            stan::math::fill(rawCumTh, DUMMY_VAR__);
            current_statement_begin__ = 128;
            double maxSpan;
            (void) maxSpan;  // dummy to suppress unused var warning
            stan::math::initialize(maxSpan, DUMMY_VAR__);
            stan::math::fill(maxSpan, DUMMY_VAR__);
            stan::math::assign(maxSpan,(max(rawTheta) - min(rawTheta)));
            // do transformed parameters statements
            current_statement_begin__ = 129;
            stan::math::assign(threshold, multiply(maxSpan, rawThreshold));
            current_statement_begin__ = 130;
            stan::math::assign(rawCumTh, cumulative_sum(threshold));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t threshold_j_1_max__ = NTHRESH;
                for (size_t j_1__ = 0; j_1__ < threshold_j_1_max__; ++j_1__) {
                    vars__.push_back(threshold(j_1__));
                }
                size_t rawCumTh_j_1_max__ = NTHRESH;
                for (size_t j_1__ = 0; j_1__ < rawCumTh_j_1_max__; ++j_1__) {
                    vars__.push_back(rawCumTh(j_1__));
                }
                vars__.push_back(maxSpan);
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 148;
            validate_non_negative_index("log_lik", "N", N);
            std::vector<double> log_lik(N, double(0));
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 150;
            validate_non_negative_index("theta", "NPA", NPA);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta(NPA);
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            stan::math::assign(theta,rawTheta);
            // generated quantities statements
            current_statement_begin__ = 151;
            stan::math::assign(theta, subtract(theta, mean(theta)));
            current_statement_begin__ = 152;
            stan::math::assign(theta, divide(theta, sd(theta)));
            {
            current_statement_begin__ = 154;
            int cmpStart(0);
            (void) cmpStart;  // dummy to suppress unused var warning
            stan::math::fill(cmpStart, std::numeric_limits<int>::min());
            stan::math::assign(cmpStart,1);
            current_statement_begin__ = 155;
            int cur(0);
            (void) cur;  // dummy to suppress unused var warning
            stan::math::fill(cur, std::numeric_limits<int>::min());
            stan::math::assign(cur,1);
            current_statement_begin__ = 157;
            for (int rx = 1; rx <= numRefresh; ++rx) {
                {
                current_statement_begin__ = 158;
                int nout(0);
                (void) nout;  // dummy to suppress unused var warning
                stan::math::fill(nout, std::numeric_limits<int>::min());
                stan::math::assign(nout,get_base1(numOutcome, rx, "numOutcome", 1));
                current_statement_begin__ = 159;
                int last(0);
                (void) last;  // dummy to suppress unused var warning
                stan::math::fill(last, std::numeric_limits<int>::min());
                stan::math::assign(last,((cur + nout) - 1));
                current_statement_begin__ = 160;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_min_max(cur, last), stan::model::nil_index_list()), 
                            pairwise_loo(rcat, weight, nout, cmpStart, get_base1(refresh, rx, "refresh", 1), scale, alpha, get_base1(theta, get_base1(pa1, rx, "pa1", 1), "theta", 1), get_base1(theta, get_base1(pa2, rx, "pa2", 1), "theta", 1), rawCumTh, pstream__), 
                            "assigning variable log_lik");
                current_statement_begin__ = 163;
                stan::math::assign(cmpStart, (cmpStart + get_base1(refresh, rx, "refresh", 1)));
                current_statement_begin__ = 164;
                stan::math::assign(cur, (cur + get_base1(numOutcome, rx, "numOutcome", 1)));
                }
            }
            }
            // validate, write generated quantities
            current_statement_begin__ = 148;
            size_t log_lik_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
                vars__.push_back(log_lik[k_0__]);
            }
            current_statement_begin__ = 150;
            size_t theta_j_1_max__ = NPA;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                vars__.push_back(theta(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_unidim_ll";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t rawTheta_j_1_max__ = NPA;
        for (size_t j_1__ = 0; j_1__ < rawTheta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawTheta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawThreshold_j_1_max__ = NTHRESH;
        for (size_t j_1__ = 0; j_1__ < rawThreshold_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawThreshold" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t threshold_j_1_max__ = NTHRESH;
            for (size_t j_1__ = 0; j_1__ < threshold_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "threshold" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t rawCumTh_j_1_max__ = NTHRESH;
            for (size_t j_1__ = 0; j_1__ < rawCumTh_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rawCumTh" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "maxSpan";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t log_lik_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_j_1_max__ = NPA;
        for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t rawTheta_j_1_max__ = NPA;
        for (size_t j_1__ = 0; j_1__ < rawTheta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawTheta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rawThreshold_j_1_max__ = NTHRESH;
        for (size_t j_1__ = 0; j_1__ < rawThreshold_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rawThreshold" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t threshold_j_1_max__ = NTHRESH;
            for (size_t j_1__ = 0; j_1__ < threshold_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "threshold" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t rawCumTh_j_1_max__ = NTHRESH;
            for (size_t j_1__ = 0; j_1__ < rawCumTh_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rawCumTh" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "maxSpan";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t log_lik_k_0_max__ = N;
        for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_j_1_max__ = NPA;
        for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_unidim_ll_namespace::model_unidim_ll stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
