% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcadaptClass.R
\name{create.pcadapt}
\alias{create.pcadapt}
\title{pcadapt objects}
\usage{
create.pcadapt(output.filename, K, method, data.type, min.maf)
}
\arguments{
\item{output.filename}{a character string indicating which outputs from PCAdapt
fast should be processed.}

\item{K}{an integer specifying the number of principal components to retain.}

\item{method}{a character string specifying the method to be used to compute
the p-values. Four statistics are currently available, \code{"mahalanobis"},
\code{"communality"}, and \code{"componentwise"}.}

\item{data.type}{a character string specifying the type of data being read, either
a \code{genotype} matrix (\code{data.type="genotype"}), or a matrix of allele
frequencies (\code{data.type="pool"}).}

\item{min.maf}{a value between \code{0} and \code{0.45} specifying the threshold
of minor allele frequencies above which p-values are computed.}
}
\description{
\code{create.pcadapt} loads the numerical quantities needed to compute the test
statistics, and stores them in an object of class \code{pcadapt}.
}

