% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccc.R
\name{ccc}
\alias{ccc}
\title{Complex Chronic Conditions (CCC)}
\usage{
ccc(data, id, dx_cols = NULL, pc_cols = NULL, icdv)
}
\arguments{
\item{data}{a \code{data.frame} containing a patient id and all the ICD-9-CM
or ICD-10-CM codes.  The \code{data.frame} passed to the function should be
in wide format.}

\item{id}{bare name of the column containing the patient id}

\item{dx_cols, pc_cols}{column names with the diagnostic codes and procedure
codes respectively.  These argument are passed to \code{\link[dplyr]{select}}.}

\item{icdv}{ICD version 9 or 10}
}
\value{
A \code{data.frame} with a column for the subject id and integer (0
or 1) columns for each each of the categories.
}
\description{
Generate CCC and CCC subcategory flags and the number of categories.
}
\details{
It is recommended that you view the codes defining the CCC via
\code{\link{get_codes}} and make sure that the ICD codes in your data set are
formatted in the same way.  The ICD codes used for CCC are character strings
must be formatted as follows:
\itemize{
\item *Do not* use decimal points or other separators
\item ICD 9 codes: Codes less than 10 should be left padded with 2 zeros. Codes
less than 100 should be left padded with 1 zero.
}

See `vignette("pccc-overview")` for more details.
}
\examples{
eg_data <- data.frame(id = letters,
                      dx1 = c(NA, NA, sample(get_codes(10)[["hemato_immu", "dx"]], 24)),
                      dx2 = c("A", sample(get_codes(10)[["gi", "dx"]], 25)),
                      dx3 = LETTERS,
                      pc1 = c("B", sample(get_codes(10)[["cvd", "pc"]], 25)),
                      pc2 = LETTERS,
                      other_col = LETTERS)

ccc(eg_data, 
    id,
    dx_cols = dplyr::starts_with("dx"),
    pc_cols = dplyr::starts_with("pc"),
    icdv = 10)

}
\references{
See \code{\link{pccc-package}} for published paper on the topic of identifying
Complex Chronic Conditions
}
\seealso{
\code{\link{get_codes}} to view the ICD codes used to define the
CCC.  \code{\link[dplyr]{select}} for more examples and details on how to
identify and select the diagnostic and procedure code columns.
}
