% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsPEend1D}
\alias{NumArcsPEend1D}
\title{Number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) - end interval case}
\usage{
NumArcsPEend1D(dat, r, int)
}
\arguments{
\item{dat}{A vector of 1D points which constitute the vertices of the digraph}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region; must be \eqn{\ge 1}}

\item{int}{A vector of two real numbers representing an interval}
}
\value{
Number of arcs for the PE-PCD with vertices being 1D data set, \code{dat},
expansion parameter, \eqn{r \ge 1}, for the end intervals.
}
\description{
Returns the number of arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) whose
vertices are a 1D numerical data set, \code{dat}, outside the interval \eqn{int=(a,b)}.

PE proximity region is constructed only with expansion parameter \eqn{r \ge 1} for points outside the interval \eqn{(a,b)}.
End vertex regions are based on the end points of the interval,
i.e., the corresponding vertex region is an interval as \eqn{(-\infty,a)} or \eqn{(b,\infty)} for the interval \eqn{(a,b)}.
For the number of arcs, loops are not allowed, so arcs are only possible for points outside
the interval, \code{int}, for this function.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
a<-0; b<-10; int<-c(a,b)

n<-5
datL<-runif(n,a-5,a)
datR<-runif(n,b,b+5)
dat<-c(datL,datR)

r<-2
NumArcsPEend1D(dat,r,int)

NumArcsPEend1D(dat,r=1.2,int)
NumArcsPEend1D(dat,r=4,int)

n<-10  #try also n<-20
dat2<-runif(n,a-5,b+5)
NumArcsPEend1D(dat2,r,int)

NumArcsPEend1D(dat,r,int)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsPEmid1D}}, \code{\link{NumArcsCSmid1D}}, and \code{\link{NumArcsCSend1D}}
}
