% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{funsMuVarCSend1D}
\alias{funsMuVarCSend1D}
\alias{muCSend1D}
\alias{asyvarCSend1D}
\title{Two functions: \code{muCSend1D} and \code{asyvarCSend1D} ---

Returns the mean and (asymptotic) variance of arc density of Central Similarity Proximity Catch Digraph (CS-PCD)
for 1D data - end interval case}
\usage{
muCSend1D(t)

asyvarCSend1D(t)
}
\arguments{
\item{t}{A positive real number which serves as the expansion parameter in CS proximity region}
}
\value{
\code{muCSend1D} returns the mean and \code{asyvarCSend1D} returns the asymptotic variance of the
arc density of CS-PCD for uniform data in end intervals
}
\description{
\code{muCSend1D} returns the mean of the arc density of CS-PCD
and \code{asyvarCSend1D} returns the asymptotic variance of the arc density of CS-PCD
for a given expansion parameter \eqn{t>0}  for 1D uniform data in the left and right end intervals
for the interval \eqn{(a,b)}.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
#Examples for muCSend1D
muCSend1D(1.2)

tseq<-seq(0.01,5,by=.05)
ltseq<-length(tseq)

mu.end<-vector()
for (i in 1:ltseq)
{
  mu.end<-c(mu.end,muCSend1D(tseq[i]))
}

oldpar <- par(mfrow = c(1,2))
par(mar = c(5,4,4,2) + 0.1)
plot(tseq, mu.end,type="l",
ylab=expression(paste(mu,"(t)")),xlab="t",lty=1,xlim=range(tseq),ylim=c(0,1))
par(oldpar)


#Examples for asyvarCSend1D
asyvarCSend1D(1.2)

tseq<-seq(.01,5,by=.05)
ltseq<-length(tseq)

var.end<-vector()
for (i in 1:ltseq)
{
  var.end<-c(var.end,asyvarCSend1D(tseq[i]))
}

oldpar <- par(mfrow = c(1,2))
par(mar=c(5,5,4,2))
plot(tseq, var.end,type="l",xlab="t",ylab=expression(paste(sigma^2,"(t)")),lty=1,xlim=range(tseq))
par(oldpar)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{muPEend1D}} and \code{\link{asyvarPEend1D}}
}
