% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{ArcsPEMI}
\alias{ArcsPEMI}
\title{The arcs of Proportional Edge Proximity Catch Digraph (PE-PCD) for 1D data - multiple interval case}
\usage{
ArcsPEMI(Xp, Yp, r, c)
}
\arguments{
\item{Xp}{A set or vector of 1D points which constitute the vertices of the PE-PCD.}

\item{Yp}{A set or vector of 1D points which constitute the end points of the intervals.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
A list with the elements
\item{type}{A description of the type of the digraph}
\item{parameters}{Parameters of the digraph, here, they are expansion and centrality parameters.}
\item{tess.points}{Points on which the tessellation of the study region is performed, here, tessellation
is the intervalization of the real line based on \code{Yp} points.}
\item{tess.name}{Name of data set used in tessellation, it is \code{Yp} for this function}
\item{vertices}{Vertices of the digraph, \code{Xp} points}
\item{vert.name}{Name of the data set which constitute the vertices of the digraph}
\item{S}{Tails (or sources) of the arcs of PE-PCD for 1D data}
\item{E}{Heads (or arrow ends) of the arcs of PE-PCD for 1D data}
\item{mtitle}{Text for "main" title in the plot of the digraph}
\item{quant}{Various quantities for the digraph: number of vertices, number of partition points,
number of intervals, number of arcs, and arc density.}
}
\description{
An object of class "PCDs".
Returns arcs as tails (or sources) and heads (or arrow ends) for 1D data set \code{Xp} as the vertices
of PE-PCD.  \code{Yp} determines the end points of the intervals.

For this function, PE proximity regions are constructed data points inside or outside the intervals based
on \code{Yp} points with expansion parameter \eqn{r \ge 1} and centrality parameter \code{c} in \eqn{(0,1)}. That is, for this function,
arcs may exist for points in the middle or end intervals.
It also provides various descriptions and quantities about the arcs of the PE-PCD
such as number of arcs, arc density, etc.

Equivalent to function  \code{\link{ArcsPE1D}}.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
r<-2
c<-.4
a<-0; b<-10;

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
xr<-range(a,b)
xf<-(xr[2]-xr[1])*.1

Xp<-runif(nx,a-xf,b+xf)
Yp<-runif(ny,a,b)

Arcs<-ArcsPEMI(Xp,Yp,r,c)
Arcs
summary(Arcs)
plot(Arcs)

S<-Arcs$S
E<-Arcs$E

ArcsPEMI(Xp,Yp,r,c)
ArcsPEMI(Xp,Yp+10,r,c)

jit<-.1
yjit<-runif(nx,-jit,jit)

Xlim<-range(a,b,Xp,Yp)
xd<-Xlim[2]-Xlim[1]

plot(cbind(a,0),
main="arcs of PE-PCD for points (jittered along y-axis)\n in middle intervals ",
xlab=" ", ylab=" ", xlim=Xlim+xd*c(-.05,.05),ylim=3*c(-jit,jit),pch=".")
abline(h=0,lty=1)
points(Xp, yjit,pch=".",cex=3)
abline(v=Yp,lty=2)
arrows(S, yjit, E, yjit, length = .05, col= 4)

r<-2
c<-.4
a<-0; b<-10;
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;
Xp<-runif(nx,a,b)
Yp<-runif(ny,a,b)
ArcsPEMI(Xp,Yp,r,c)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ArcsPE1D}}, \code{\link{ArcsPEmid1D}}, \code{\link{ArcsPEend1D}}, and \code{\link{ArcsCSMI}}
}
