% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{centMc}
\alias{centMc}
\title{Parameterized center of an interval}
\usage{
centMc(int, c)
}
\arguments{
\item{int}{A vector with two entries representing an interval.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
(parameterized) center inside \code{int}
}
\description{
Returns the (parameterized) center, \eqn{M_c}, of the interval, \eqn{int=(a,b)}, parameterized by \code{c} in \eqn{(0,1)}
so that \eqn{100c} \% of the length of interval is to the left of \eqn{M_c} and \eqn{100(1-c)} \% of the length of the interval
is to the right of \eqn{M_c}. That is, for the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.

See also (\insertCite{ceyhan:metrika-2012,ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
c<-.4
a<-0; b<-10; int<-c(a,b)
int
centMc(int,c)

c<-.3
a<-2; b<-4; int<-c(a,b)
centMc(int,c)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{centersMc}}
}
