% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{runif.tetra}
\alias{runif.tetra}
\title{Generation of Uniform Points in a tetrahedron}
\usage{
runif.tetra(k, th)
}
\arguments{
\item{k}{A positive integer representing the number of uniform points to be generated in the tetrahedron.}

\item{th}{Four 3D points, stacked row-wise, each row representing a vertex of the tetrahedron.}
}
\value{
A list with the elements
\item{type}{The type of the pattern from which points are to be generated}
\item{mtitle}{The "main" title for the plot of the point pattern}
\item{tess.points}{The vertices of the support of the uniformly generated points, it is the tetrahedron
\code{th} for this function}
\item{gen.points}{The output set of generated points uniformly in the tetrahedron, \code{th}.}
\item{out.region}{The outer region which contains the support region, \code{NULL} for this function.}
\item{desc.pat}{Description of the point pattern from which points are to be generated}
\item{num.points}{The vector of two numbers, which are the number of generated points and the number
of vertices of the support points (here it is 4).}
\item{txt4pnts}{Description of the two numbers in \code{num.points}}
\item{xlimit, ylimit, zlimit}{The ranges of the x-, y- and z-coordinates of the support, \code{th}}
}
\description{
An object of class "Uniform".
Generates \code{k} points uniformly in the general tetrahedron \code{th} whose vertices are stacked row-wise.
}
\examples{
\donttest{
A<-sample(1:12,3); B<-sample(1:12,3); C<-sample(1:12,3); D<-sample(1:12,3)
tetra<-rbind(A,B,C,D)

n<-10  #try also n<-100

set.seed(1)
Xdt<-runif.tetra(n,tetra)
Xdt
summary(Xdt)
plot(Xdt)

Dt<-Xdt$g

Xlim<-range(tetra[,1],Dt[,1])
Ylim<-range(tetra[,2],Dt[,2])
Zlim<-range(tetra[,3],Dt[,3])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]
zd<-Zlim[2]-Zlim[1]

plot3D::scatter3D(Dt[,1],Dt[,2],Dt[,3], theta =225, phi = 30, bty = "g",
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05), zlim=Zlim+zd*c(-.05,.05),
          pch = 20, cex = 1, ticktype = "detailed")
#add the vertices of the tetrahedron
plot3D::points3D(tetra[,1],tetra[,2],tetra[,3], add=TRUE)
L<-rbind(A,A,A,B,B,C); R<-rbind(B,C,D,C,D,D)
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3], add=TRUE,lwd=2)

plot3D::text3D(tetra[,1],tetra[,2],tetra[,3], labels=c("A","B","C","D"), add=TRUE)

runif.tetra(n,tetra)

dat.fr<-data.frame(a=tetra)
runif.tetra(n,dat.fr)
}

\dontrun{
#need to install scatterplot3d package and call "library(scatterplot3d)"
s3d<-scatterplot3d(Dt, highlight.3d=TRUE,xlab="x",ylab="y",zlab="z",
                    col.axis="blue", col.grid="lightblue",
                    main="3D Scatterplot of the data", pch=20)
 s3d$points3d(tetra,pch=20,col="blue")
 }

}
\seealso{
\code{\link{runif.stdtetra}} and \code{\link{runif.tri}}
}
