% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{circ.cent.tetra}
\alias{circ.cent.tetra}
\title{Circumcenter of a general tetrahedron}
\usage{
circ.cent.tetra(th)
}
\arguments{
\item{th}{Four 3D points, stacked row-wise, each row representing a vertex of the tetrahedron.}
}
\value{
circumcenter of the tetrahedron \code{th}
}
\description{
Returns the circumcenter a given tetrahedron \code{th} with vertices stacked row-wise.
}
\examples{
\donttest{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)

CC<-circ.cent.tetra(tetra)
CC

Xlim<-range(tetra[,1],CC[1])
Ylim<-range(tetra[,2],CC[2])
Zlim<-range(tetra[,3],CC[3])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]
zd<-Zlim[2]-Zlim[1]

plot3D::scatter3D(tetra[,1],tetra[,2],tetra[,3], phi =0,theta=40, bty = "g",
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05), zlim=Zlim+zd*c(-.05,.05),
          pch = 20, cex = 1, ticktype = "detailed")
#add the vertices of the tetrahedron
plot3D::points3D(CC[1],CC[2],CC[3], add=TRUE)
L<-rbind(A,A,A,B,B,C); R<-rbind(B,C,D,C,D,D)
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3], add=TRUE,lwd=2)

plot3D::text3D(tetra[,1],tetra[,2],tetra[,3], labels=c("A","B","C","D"), add=TRUE)

D1<-(A+B)/2; D2<-(A+C)/2; D3<-(A+D)/2; D4<-(B+C)/2; D5<-(B+D)/2; D6<-(C+D)/2;
L<-rbind(D1,D2,D3,D4,D5,D6); R<-
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3], add=TRUE,lty=2)

plot3D::text3D(CC[1],CC[2],CC[3], labels="CC", add=TRUE)

dat.fr<-data.frame(a=tetra)
circ.cent.tetra(dat.fr)
}

}
\seealso{
\code{\link{circ.cent.tri}}
}
\author{
Elvan Ceyhan
}
