% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{TSDomPEBin1D}
\alias{TSDomPEBin1D}
\title{A test of segregation/association based on domination number of Proportional Edge Proximity Catch Digraph
(PE-PCD) for 1D data - Binomial Approximation}
\usage{
TSDomPEBin1D(
  Xp,
  Yp,
  support.int,
  c = 0.5,
  end.int.cor = FALSE,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)
}
\arguments{
\item{Xp}{A set of 1D points which constitute the vertices of the PE-PCD.}

\item{Yp}{A set of 1D points which constitute the end points of the partition intervals.}

\item{support.int}{Support interval \eqn{(a,b)} with \eqn{a<b}. Uniformity of \code{Xp} points in this interval
is tested.}

\item{c}{A positive real number which serves as the centrality parameter in PE proximity region;
must be in \eqn{(0,1)} (default \code{c=.5}).}

\item{end.int.cor}{A logical argument for end interval correction, default is \code{FALSE},
recommended when both \code{Xp} and \code{Yp} have the same interval support.}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}.}

\item{conf.level}{Level of the confidence interval, default is \code{0.95}, for the probability of success
(i.e., \eqn{Pr(}domination number\eqn{=2)} for PE-PCD whose vertices are the 1D data set \code{Xp}.}
}
\value{
A \code{list} with the elements
\item{statistic}{Test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding \code{alternative}.}
\item{conf.int}{Confidence interval for \eqn{Pr(}domination number\eqn{=2)} at the given level \code{conf.level} and
depends on the type of \code{alternative}.}
\item{estimate}{A \code{vector} with two entries: first is is the estimate of the parameter, i.e.,
\eqn{Pr(}domination number\eqn{\le 1)} and second is the domination number}
\item{null.value}{Hypothesized value for the parameter, i.e., the null value for \eqn{Pr(}domination number\eqn{\le 1)}}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set}
}
\description{
An object of class \code{"htest"} (i.e., hypothesis test) function which performs a hypothesis test of complete spatial
randomness (CSR) or uniformity of \code{Xp} points within the partition intervals based on \code{Yp} points (both residing in the
support interval \eqn{(a,b)}).
The test is for testing the spatial interaction between \code{Xp} and \code{Yp} points.

The null hypothesis is uniformity of \code{Xp} points on \eqn{(a,b)}.
\code{Yp} determines the end points of the intervals (i.e., partition the real line via its spacings called intervalization)
where end points are the order statistics of \code{Yp} points.

The alternatives are segregation (where \code{Xp} points cluster away from \code{Yp} points i.e., cluster around the centers of the
partition intervals) and association (where \code{Xp} points cluster around \code{Yp} points). The test is based on the (asymptotic) binomial
distribution of the domination number of PE-PCD for uniform 1D data in the partition intervals based on \code{Yp} points.

The function yields the test statistic, \eqn{p}-value for the corresponding
alternative, the confidence interval, estimate and null value for the parameter of interest (which is
\eqn{Pr(}domination number\eqn{=2)}), and method and name of the data set used.

Under the null hypothesis of uniformity of \code{Xp} points in the intervals based on \code{Yp} points, probability of success
(i.e., \eqn{Pr(}domination number\eqn{\le 1)}) equals to its expected value) and
\code{alternative} could be two-sided, or left-sided (i.e., data is accumulated around the \code{Yp} points, or association)
or right-sided (i.e., data is accumulated around the centers of the partition intervals, or segregation).

PE proximity region is constructed with the expansion parameter \eqn{r \ge 1} and centrality parameter \code{c} which yields
\eqn{M}-vertex regions. More precisely, for a middle interval \eqn{(y_{(i)},y_{(i+1)})}, the center is
\eqn{M=y_{(i)}+c(y_{(i+1)}-y_{(i)})} for the centrality parameter \code{c}.
For a given \eqn{c \in (0,1)}, the
expansion parameter \eqn{r} is taken to be \eqn{1/\max(c,1-c)} which yields non-degenerate asymptotic distribution of the
domination number.

The test statistic is based on the binomial distribution, when success is defined as domination number being
equal to 1 in the one interval case (i.e., number of successes is equal to domination number \eqn{\le 1} in the partition intervals).
That is, the test statistic is based on the domination number for \code{Xp} points inside range of \code{Yp} points
for the PE-PCD and default end interval correction, \code{end.int.cor}, is \code{FALSE}
where \code{M} is the center that yields nondegenerate asymptotic distribution for the domination number.
For this approximation to work, \code{Xp} must be at least 5 times more than \code{Yp} points
(or \code{Xp} must be at least 5 or more per partition interval).
Probability of success is the exact probability of success for the binomial distribution.

**Caveat:** This test is currently a conditional test, where \code{Xp} points are assumed to be random, while \code{Yp} points are
assumed to be fixed (i.e., the test is conditional on \code{Yp} points).
Furthermore, the test is a large sample test when \code{Xp} points are substantially larger than \code{Yp} points,
say at least 7 times more.
This test is more appropriate when supports of \code{Xp} and \code{Yp} have a substantial overlap.
Currently, the \code{Xp} points outside the range of \code{Yp} points are handled with an end interval correction factor
(see the description below and the function code.)
Removing the conditioning and extending it to the case of non-concurring supports is
an ongoing line of research of the author of the package.

See also (\insertCite{ceyhan:stat-2020;textual}{pcds}) for more on the uniformity test based on the arc
density of PE-PCDs.
}
\examples{
\dontrun{
a<-0; b<-10; supp<-c(a,b)
c<-.4

r<-1/max(c,1-c)

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-100; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-runif(nx,a,b)
Yp<-runif(ny,a,b)
TSDomPEBin1D(Xp,Yp,supp,c)
TSDomPEBin1D(Xp,Yp,supp,c,alt="l")
TSDomPEBin1D(Xp,Yp,supp,c,alt="g")
TSDomPEBin1D(Xp,Yp,supp,c,end=TRUE)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{TSDomPEBin}} and \code{\link{PEdom1D}}
}
\author{
Elvan Ceyhan
}
