% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxExtrema.R
\name{fr2edgesCM_ERstd.tri}
\alias{fr2edgesCM_ERstd.tri}
\title{The furthest points in a data set from edges in each \eqn{CM}-edge region in the standard
equilateral triangle}
\usage{
fr2edgesCM_ERstd.tri(Xp, ch.all.intri = FALSE)
}
\arguments{
\item{Xp}{A set of 2D points, some could be inside and some could be outside standard equilateral triangle
\eqn{T_e}.}

\item{ch.all.intri}{A logical argument used for checking whether all data points are inside \eqn{T_e}
(default is \code{FALSE}).}
}
\value{
A \code{list} with the elements
\item{txt1}{Edge labels as \eqn{AB=3}, \eqn{BC=1}, and \eqn{AC=2} for \eqn{T_e} (correspond to row number in Extremum Points).}
\item{txt2}{A short description of the distances as \code{"Distances to Edges"}.}
\item{type}{Type of the extrema points}
\item{desc}{A short description of the extrema points}
\item{mtitle}{The \code{"main"} title for the plot of the extrema}
\item{ext}{The extrema points, here, furthest points from edges in each edge region.}
\item{X}{The input data, \code{Xp}, can be a \code{matrix} or \code{data frame}}
\item{num.points}{The number of data points, i.e., size of \code{Xp}}
\item{supp}{Support of the data points, here, it is \eqn{T_e}.}
\item{cent}{The center point used for construction of edge regions.}
\item{ncent}{Name of the center, \code{cent}, it is center of mass \code{"CM"} for this function.}
\item{regions}{Edge regions inside the triangle, \eqn{T_e}, provided as a list.}
\item{region.names}{Names of the edge regions as \code{"er=1"}, \code{"er=2"}, and \code{"er=3"}.}
\item{region.centers}{Centers of mass of the edge regions inside \eqn{T_e}.}
\item{dist2ref}{Distances from furthest points in each edge region to the corresponding edge.}
}
\description{
An object of class \code{"Extrema"}.
Returns the furthest data points among the data set, \code{Xp}, in each \eqn{CM}-edge region from the edge in the
standard equilateral triangle \eqn{T_e=T(A=(0,0),B=(1,0),C=(1/2,\sqrt{3}/2))}.

\code{ch.all.intri} is for checking whether all data points are inside \eqn{T_e} (default is \code{FALSE}).

See also (\insertCite{ceyhan:Phd-thesis;textual}{pcds}).
}
\examples{
\dontrun{
n<-20
Xp<-runif.std.tri(n)$gen.points

Ext<-fr2edgesCM_ERstd.tri(Xp)
Ext
summary(Ext)
plot(Ext,asp=1)

ed.far<-Ext

Xp2<-rbind(Xp,c(.8,.8))
fr2edgesCM_ERstd.tri(Xp2)
fr2edgesCM_ERstd.tri(Xp2,ch.all.intri = FALSE) #gives error if ch.all.intri = TRUE

A<-c(0,0); B<-c(1,0); C<-c(0.5,sqrt(3)/2);
Te<-rbind(A,B,C)
CM<-(A+B+C)/3
p1<-(A+B)/2
p2<-(B+C)/2
p3<-(A+C)/2

Xlim<-range(Te[,1],Xp[,1])
Ylim<-range(Te[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(A,pch=".",xlab="",ylab="",
main="Furthest Points in CM-Edge Regions \n of Std Equilateral Triangle from its Edges",
axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Te)
L<-Te; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(Xp,xlab="",ylab="")
points(ed.far$ext,pty=2,pch=4,col="red")

txt<-rbind(Te,CM,p1,p2,p3)
xc<-txt[,1]+c(-.03,.03,.03,-.06,0,0,0)
yc<-txt[,2]+c(.02,.02,.02,.02,0,0,0)
txt.str<-c("A","B","C","CM","re=2","re=3","re=1")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{fr2vertsCC_VRbas.tri}}, \code{\link{fr2vertsCC_VR}}, \code{\link{kfr2vertsCC_VRbas.tri}},
\code{\link{kfr2vertsCC_VR}}, and \code{\link{cl2edges.std.tri}}
}
\author{
Elvan Ceyhan
}
