% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_linear_combo.R
\name{model_singular}
\alias{model_singular}
\title{Model an individual phenotype using PCSS}
\usage{
model_singular(formula, n, means, covs, ...)
}
\arguments{
\item{formula}{an object of class \code{formula} whose dependent variable is
only variable. All model terms must be accounted for in \code{means}
and \code{covs}.}

\item{n}{sample size.}

\item{means}{named vector of predictor and response means.}

\item{covs}{named matrix of the covariance of all model predictors and the
responses.}

\item{...}{additional arguments}
}
\value{
an object of class \code{"pcsslm"}.

  An object of class \code{"pcsslm"} is a list containing at least the 
  following components:
    \item{call}{the matched call}
    \item{terms}{the \code{terms} object used}
    \item{coefficients}{a \eqn{p x 4} matrix with columns for the 
      estimated coefficient, its standard error, t-statistic and
      corresponding (two-sided) p-value.}
    \item{sigma}{the square root of the estimated variance of the random
      error.}
    \item{df}{degrees of freedom, a 3-vector \eqn{p, n-p, p*}, the
      first being the number of non-aliased coefficients, the last being
      the total number of coefficients.}
    \item{fstatistic}{a 3-vector with the value of the F-statistic with its
      numerator and denominator degrees of freedom.}
    \item{r.squared}{\eqn{R^2}, the 'fraction of variance explained by the 
      model'.}
    \item{adj.r.squared}{the above \eqn{R^2} statistic \emph{'adjusted'},
      penalizing for higher \eqn{p}.}
    \item{cov.unscaled}{a \eqn{p x p} matrix of (unscaled) covariances of the
      \eqn{coef[j], j=1,...p}.}
    \item{Sum Sq}{a 3-vector with the model's Sum of Squares Regression 
      (SSR), Sum of Squares Error (SSE), and Sum of Squares Total (SST).}
}
\description{
\code{model_singular} calculates the linear model for a singular
  phenotype as a function of a set of predictors.
}
\examples{
ex_data <- pcsstools_example[c("g1", "x1", "y1")]
means <- colMeans(ex_data)
covs <- cov(ex_data)
n <- nrow(ex_data)

model_singular(
  y1 ~ g1 + x1,
  n = n, means = means, covs = covs
)
summary(lm(y1 ~ g1 + x1, data = ex_data))
}
\references{
{

  \insertRef{wolf_computationally_2020}{pcsstools}
  
}
}
