% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desire_lines.R
\name{get_desire_lines}
\alias{get_desire_lines}
\title{Desire lines}
\usage{
get_desire_lines(region = NULL, n = NULL, omit_intrazonal = FALSE)
}
\arguments{
\item{region}{The PCT region or local authority to download data from (e.g. \code{west-yorkshire} or \code{Leeds}).
See \code{View(pct_regions_lookup)} for a full list of possible region names.}

\item{n}{top n number of destinations with most trips in the 2011 census
within the \code{region}.}

\item{omit_intrazonal}{should intrazonal OD pairs be omited from result?
\code{FALSE} by default.}
}
\description{
This function generates "desire lines" from census 2011 data.
By default gets all desire lines from census in region, but
can get the top \code{n}.
}
\examples{
\donttest{
if(curl::has_internet()) {
desire_lines = get_desire_lines("wight")
plot(desire_lines)
intra_zonal = desire_lines$geo_code1 == desire_lines$geo_code2
plot(desire_lines[intra_zonal, ])
}
}
}
