/*
 * Decompiled with CFR 0.152.
 */
package interfaces;

import interfaces.CharacterVector;
import interfaces.IntegerVector;
import interfaces.NumericVector;
import interfaces.VectorList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PdfExtractor
extends PDFTextStripper {
    public static Boolean adjust_direction = false;
    public static Boolean font_size_in_pt = false;
    public static int page_id = 0;
    public static PDDocument document = null;
    public static MemoryUsageSetting memory_options = null;
    public static VectorList df = null;
    public static VectorList meta = null;

    public static void set_memory_options(int max_main_memory, String temp_dir) {
        System.setProperty("pdfbox.fontcache", temp_dir);
        memory_options = max_main_memory > 0 ? MemoryUsageSetting.setupMixed((long)((long)max_main_memory * 1024L * 1024L), (long)-1L).setTempDir(new File(temp_dir)) : MemoryUsageSetting.setupMainMemoryOnly();
    }

    public static void load(String pdf_file, String password) throws InvalidPasswordException, IOException {
        document = password.length() > 0 ? PDDocument.load((File)new File(pdf_file), (String)password, (MemoryUsageSetting)memory_options) : PDDocument.load((File)new File(pdf_file), (MemoryUsageSetting)memory_options);
    }

    public static int read_chars(int[] pages, String adj, String pt) throws IOException {
        df = new VectorList();
        meta = new VectorList();
        adjust_direction = Boolean.parseBoolean(adj);
        font_size_in_pt = Boolean.parseBoolean(pt);
        PdfExtractor stripper = new PdfExtractor();
        stripper.setSortByPosition(true);
        for (int k = 0; k < pages.length; ++k) {
            page_id = pages[k];
            PDPage page = document.getPage(page_id - 1);
            meta.append("pid", page_id);
            meta.append("rotation", page.getRotation());
            meta.append("x0", Float.valueOf(page.getBBox().getLowerLeftX()));
            meta.append("y0", Float.valueOf(page.getBBox().getLowerLeftY()));
            meta.append("x1", Float.valueOf(page.getBBox().getUpperRightX()));
            meta.append("y1", Float.valueOf(page.getBBox().getUpperRightY()));
            stripper.setStartPage(page_id);
            stripper.setEndPage(page_id);
            OutputStreamWriter dummy = new OutputStreamWriter(new ByteArrayOutputStream());
            stripper.writeText(document, dummy);
        }
        return 0;
    }

    protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
        for (TextPosition text : textPositions) {
            df.append("pid", page_id);
            df.append("text", text.getUnicode());
            df.append("font", text.getFont().getName());
            if (font_size_in_pt.booleanValue()) {
                df.append("size", Float.valueOf(text.getFontSizeInPt()));
            } else {
                df.append("size", Float.valueOf(text.getFontSize()));
            }
            if (adjust_direction.booleanValue()) {
                df.append("x0", Float.valueOf(text.getXDirAdj()));
                df.append("y0", Float.valueOf(text.getYDirAdj()));
                df.append("height", Float.valueOf(text.getHeightDir()));
                df.append("width", Float.valueOf(text.getWidthDirAdj()));
            } else {
                df.append("x0", Float.valueOf(text.getX()));
                df.append("y0", Float.valueOf(text.getY()));
                df.append("height", Float.valueOf(text.getHeight()));
                df.append("width", Float.valueOf(text.getWidth()));
            }
            df.append("x1", Float.valueOf(text.getEndX()));
            df.append("y1", Float.valueOf(text.getEndY()));
            df.append("xscale", Float.valueOf(text.getXScale()));
            df.append("yscale", Float.valueOf(text.getYScale()));
            df.append("rotation", Float.valueOf(text.getDir()));
            df.append("space_width", Float.valueOf(text.getWidthOfSpace()));
        }
    }

    public static int read_text(int[] pages) throws IOException {
        df = new VectorList();
        PDFTextStripper stripper = new PDFTextStripper();
        for (int k = 0; k < pages.length; ++k) {
            page_id = pages[k];
            stripper.setStartPage(page_id);
            stripper.setEndPage(page_id);
            df.append("pid", page_id);
            df.append("text", stripper.getText(document));
        }
        return 0;
    }

    public static int number_of_pages() {
        int npages = -1;
        npages = document.getNumberOfPages();
        return npages;
    }

    public static PDDocumentInformation document_info() {
        return document.getDocumentInformation();
    }

    public static float version() {
        return document.getVersion();
    }

    public static void close_document() throws IOException {
        document.close();
    }

    public static IntegerVector test_int() {
        IntegerVector x = new IntegerVector();
        x.add(1);
        x.add(2);
        return x;
    }

    public static NumericVector test_dbl() {
        NumericVector x = new NumericVector();
        x.add(1.1);
        x.add(2.2);
        return x;
    }

    public static CharacterVector test_char() {
        CharacterVector x = new CharacterVector();
        x.add("1");
        x.add("2");
        return x;
    }

    public static VectorList test_vecli() {
        VectorList x = new VectorList();
        x.append("ivec", 0);
        x.append("ivec", 1);
        x.append("cvec", "abc");
        x.append("cvec", "cdf");
        return x;
    }

    public static int test_pages(int[] pages) {
        return pages.length;
    }
}

