% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_retype.R
\name{form_retype}
\alias{form_retype}
\title{Change type of pdqr-function}
\usage{
form_retype(f, type = NULL, method = "value")
}
\arguments{
\item{f}{A pdqr-function.}

\item{type}{A desired type of output. Should be one of "discrete" or
"continuous". If \code{NULL} (default), it is chosen as an opposite of \code{f}'s
type.}

\item{method}{Retyping method. Should be one of "value", "piecelin", "dirac".}
}
\value{
A pdqr-function with type equal to input \code{type}.
}
\description{
Modify \link[=meta_type]{type} of pdqr-function using method of choice.
}
\details{
If type of \code{f} is equal to input \code{type} then \code{f} is returned.

Method "value" uses renormalized columns of \code{f}'s "x_tbl" metadata as values
for output's "x_tbl" metadata. In other words, it preserves ratios between
values of d-function at certain "x" points. Its main advantages are that this
method can work well with any pdqr type and that two consecutive conversions
return the same function. Conversion algorithm is as follows:
\itemize{
\item Retyping from "continuous" to \code{type} "discrete" is done by creating
pdqr-function of corresponding class with the following "x_tbl" metadata: "x"
column is the same as in \code{f}; "prob" column is equal to \code{f}'s "y" column
after renormalization (so that their sum is 1).
\item Retyping from "discrete" to \code{type} "continuous" is done in the same
fashion: "x" column is the same; "y" column is equal to \code{f}'s "prob" column
after renormalization (so that total integral of piecewise-linear density is
equal to 1).
}

Method "piecelin" (default) should be used mostly for converting from
"continuous" to "discrete" type. It uses the fact that 'pdqr' densities are
piecewise-linear (linear in intervals between values of "x" column of
\link[=meta_x_tbl]{"x_tbl" metadata}) on their \link[=meta_support]{support}:
\itemize{
\item Retyping from "continuous" to \code{type} "discrete" is done by computing "x"
values as centers of interval masses with probabilities equal to interval
total probabilities.
\item Retyping from "discrete" to \code{type} "continuous" is made approximately by
trying to compute "x" grid, for which "x" values of input distribution are
going to be centers of mass. Algorithm is approximate and might result into a
big errors in case of small number of "x" values or if they are not
"suitable" for this kind of transformation.
}

Method "dirac" is used mostly for converting from "discrete" to "continuous"
type (for example, in \code{form_mix()} in case different types of input
pdqr-functions). It works in the following way:
\itemize{
\item Retyping from "continuous" to \code{type} "discrete" works only if "x_tbl"
metadata represents a mixture of dirac-like distributions. In that case it is
transformed to have "x" values from centers of those dirac-like distributions
with corresponding probabilities.
\item Retyping from "discrete" to \code{type} "continuous" works by transforming each
"x" value from "x_tbl" metadata into dirac-like distribution with total
probability taken from corresponding value of "prob" column. Output
essentially represents a mixture of dirac-like distributions.
}
}
\examples{
my_con <- new_d(data.frame(x = 1:5, y = c(1, 2, 3, 2, 1)/9), "continuous")
meta_x_tbl(my_con)

  # By default, conversion is done to the opposite type
my_dis <- form_retype(my_con)
meta_x_tbl(my_dis)

# Default retyping (with method "value") is accurate when doing consecutive
# retyping
my_con_2 <- form_retype(my_dis, "continuous")
meta_x_tbl(my_con_2)

# Method "dirac"
my_dirac <- form_retype(my_dis, "continuous", method = "dirac")
meta_x_tbl(my_dirac)

# Method "piecelin"
  # From "continuous" to "discrete" (preferred direction)
my_dis_piece <- form_retype(my_con, "discrete", method = "piecelin")
meta_x_tbl(my_dis_piece)
  # Conversion from "discrete" to "continuous" is very approximate
my_con_piece <- form_retype(my_dis_piece, "continuous", method = "piecelin")
meta_x_tbl(my_con_piece)

plot(my_con, main = 'Approximate nature of method "piecelin"')
lines(my_con_piece, col = "blue")

}
\seealso{
\code{\link[=form_regrid]{form_regrid()}} for changing grid (rows of "x_tbl" metadata) of
pdqr-function.

\code{\link[=form_resupport]{form_resupport()}} for changing support of pdqr-function.

Other form functions: 
\code{\link{form_estimate}()},
\code{\link{form_mix}()},
\code{\link{form_regrid}()},
\code{\link{form_resupport}()},
\code{\link{form_smooth}()},
\code{\link{form_tails}()},
\code{\link{form_trans}()}
}
\concept{form functions}
