% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ-other.R
\name{summ_quantile}
\alias{summ_quantile}
\title{Summarize distribution with quantiles}
\usage{
summ_quantile(f, probs)
}
\arguments{
\item{f}{A pdqr-function representing distribution.}

\item{probs}{Vector of probabilities for which quantiles should be returned.}
}
\value{
A numeric vector of the same length as \code{probs} representing
corresponding quantiles.
}
\description{
Essentially, this is a more strict wrapper of \code{as_q(f)(probs)}. If any value
in \code{probs} is outside of segment \[0; 1\], an error is thrown.
}
\examples{
d_norm <- as_d(dnorm)
probs <- c(0.25, 0.5, 0.75)
all.equal(summ_quantile(d_norm, probs), as_q(d_norm)(probs))

}
\seealso{
Other summary functions: 
\code{\link{summ_center}()},
\code{\link{summ_classmetric}()},
\code{\link{summ_distance}()},
\code{\link{summ_entropy}()},
\code{\link{summ_hdr}()},
\code{\link{summ_interval}()},
\code{\link{summ_moment}()},
\code{\link{summ_order}()},
\code{\link{summ_prob_true}()},
\code{\link{summ_pval}()},
\code{\link{summ_roc}()},
\code{\link{summ_separation}()},
\code{\link{summ_spread}()}
}
\concept{summary functions}
