% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_atop_alliance.R
\name{add_atop_alliance}
\alias{add_atop_alliance}
\title{Add Alliance Treaty Obligations and Provisions (ATOP) alliance data to a dyad-year data frame}
\usage{
add_atop_alliance(data)
}
\arguments{
\item{data}{a dyad-year data frame (either "directed" or "non-directed")}
}
\value{
\code{add_atop_alliance()} takes a dyad-year data frame and adds information about
the alliance pledge in that given dyad-year from the ATOP data. These include whether there was an alliance
with a defense pledge, an offense pledge, neutrality pledge, non-aggression pledge, or pledge for consultation
in time of crisis.
}
\description{
\code{add_atop_alliance()} allows you to add Alliance Treaty Obligations and Provisions (ATOP)
data to a dyad-year data frame.
}
\details{
Data are from version 5.0 of the data.
}
\examples{

# just call `library(tidyverse)` at the top of the your script
library(magrittr)

cow_ddy \%>\% add_atop_alliance()

}
\references{
Leeds, Brett Ashley, Jeffrey M. Ritter, Sara McLaughlin Mitchell, and Andrew G. Long. 2002.
Alliance Treaty Obligations and Provisions, 1815-1944. \emph{International Interactions} 28: 237-60.
}
\author{
Steven V. Miller
}
