% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/familias2ped.R
\name{Familias2ped}
\alias{Familias2ped}
\alias{readFamiliasLoci}
\title{Convert \code{Familias} R objects to \code{ped}}
\usage{
Familias2ped(
  familiasped,
  datamatrix,
  loci,
  matchLoci = FALSE,
  prefixAdded = "added_"
)

readFamiliasLoci(loci)
}
\arguments{
\item{familiasped}{A \code{FamiliasPedigree} object or a list of such.}

\item{datamatrix}{A data frame with two columns per marker (one for each
allele) and one row per individual.}

\item{loci}{A \code{FamiliasLocus} object or a list of such.}

\item{matchLoci}{A logical, by default FALSE. If TRUE, the column names of
\code{datamatrix} are matched against \code{names(loci)}, or, if these are missing,
against the \code{name} entries of \code{loci}. The column names of \code{datamatrix} are
assumed to come in pairs with suffixes ".1" and ".2", e.g. "TH01.1",
"TH01.2", etc. If FALSE, the \code{loci} are assumed to be in correct order, and
no matching on marker name is done.}

\item{prefixAdded}{A string used as prefix when adding missing parents.}
}
\value{
A \code{ped} object, or a list of such.
}
\description{
Convert pedigrees and marker data from the \code{Familias} R package into the
\code{ped} format used by the \code{pedsuite}.
}
\details{
The definition of a \emph{pedigree} in Familias is more liberal than that
implemented in the \code{pedsuite}, which requires that each \code{ped} object is a
connected pedigree, and that each member has either 0 or 2 parents. The
conversion function \code{Familias2ped} takes care of all potential differences.
Specifically, it converts each \code{FamiliasPedigree} object into a list of
connected \code{ped} components, and adds missing parents when needed.
}
\examples{

famPed = list(id = c('mother', 'daughter', 'AF'),
              findex = c(0, 3, 0),
              mindex = c(0, 1, 0),
              sex = c('female', 'female', 'male'))
class(famPed) = "FamiliasPedigree"

datamatrix = data.frame(
  M1.1 = c(NA, 8, NA),
  M1.2 = c(NA, 9.3, NA),
  row.names = famPed$id)

famLoc = list(locusname = "M1",
              alleles = c("8" = 0.2, "9" = 0.5, "9.3" = 0.3))
class(famLoc) = "FamiliasLocus"

Familias2ped(famPed, datamatrix, loci = famLoc, matchLoci = TRUE)

}
\references{
Familias is freely available from \url{https://familias.name}.
}
\seealso{
\code{\link[=readFam]{readFam()}}.
}
