% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_cdf.R
\name{gs_cdf}
\alias{gs_cdf}
\title{Cumulative Distribution Plots for Pediatric Growth Standards}
\usage{
gs_cdf(
  metric,
  male,
  age,
  height,
  length,
  source = getOption("pedbp_pgs_source", "CDC")
)
}
\arguments{
\item{metric}{a character string denoting which growth metric to plot}

\item{male}{integer value, 1 = male, 0 = female}

\item{age}{numeric age, in months}

\item{length, height}{in centimeters}

\item{source}{a character string denoting the data source providing the
parameters needed for the estimate.  Valid values are "CDC" and "WHO".  This
can be set explicitly, or by using the \code{pedbp_pgs_source} option.}
}
\value{
a \code{ggplot} object
}
\description{
Cumulative Distribution Plots for Pediatric Growth Standards
}
\examples{

# Plot a # 13 year old male with a bmi of 21
gs_chart(metric = "bmi_for_age", male = 1) +
  ggplot2::geom_point(x = 13 * 12, y = 21)

gs_cdf(metric = "bmi_for_age", male = 1, age = 13*12) +
  ggplot2::geom_point(x = 21, y = p_bmi_for_age(21, male = 1, age = 13*12))

}
\seealso{
\itemize{
\item Distribution functions:
  \itemize{
    \item \code{\link{bmi_for_age}}
    \item \code{\link{head_circumference_for_age}}
    \item \code{\link{height_for_age}}
    \item \code{\link{length_for_age}}
    \item \code{\link{weight_for_age}}
    \item \code{\link{weight_for_length}}
    \item \code{\link{weight_for_height}}
  }
\item Plotting functions:
  \itemize{
    \item \code{\link{gs_chart}}
    \item \code{\link{gs_cdf}}
  }
\item Vignette:
  \itemize{
    \item \code{vignette(topic = "growth-standards", package = "pedbp")}
  }
}
}
