% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merlin.R
\name{likelihoodMerlin}
\alias{likelihoodMerlin}
\title{Pedigree likelihood computed by MERLIN}
\usage{
likelihoodMerlin(x, markers = seq_len(nMarkers(x)), logbase = NULL,
  verbose = FALSE, generateFiles = TRUE, cleanup = generateFiles,
  logfile = "")
}
\arguments{
\item{x}{a \code{\link{ped}} object}

\item{markers}{a vector of names or indices of markers attached to \code{x}.
(Default: all markers).}

\item{logbase}{a positive number, or NULL. If numeric, the log-likelihood is
returned, with \code{logbase} as basis for the logarithm.}

\item{verbose}{a logical.}

\item{generateFiles}{a logical. If TRUE, input files to MERLIN named
'_merlin.ped', '_merlin.dat', '_merlin.map', and '_merlin.freq' are created
in the current directory. If FALSE, no files are created.}

\item{cleanup}{a logical. If TRUE, the MERLIN input files are deleted after
the call to MERLIN.}

\item{logfile}{a character. If this is given, the MERLIN screen output will
be written to a file with this name.}
}
\value{
A number.
}
\description{
This function is a wrapper of the "--likelihood" functionality of the MERLIN
software. It computes the total likelihood of the pedigree given the
indicated marker data. For this function to work, MERLIN must be installed
and correctly pointed to in the PATH variable.
}
\details{
By default the following MERLIN command is run via \code{\link[=system]{system()}}, after creating
appropriate files in the current working directory:

\preformatted{% merlin -p _merlin.ped -d _merlin.dat -m _merlin.map -f
_merlin.freq --likelihood --bits:100 --megabytes:4000 --quiet }
}
\examples{

\donttest{
### Requires MERLIN to be installed ###

x = nuclearPed(1)
m = marker(x, "3" = 1:2)
x = setMarkers(x, m)

# Likelihood computation by MERLIN:
likelihoodMerlin(x)
}

}
\references{
\url{http://csg.sph.umich.edu/abecasis/Merlin/}
}
\author{
Magnus Dehli Vigeland
}
