% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMutationModel.R
\name{setMutationModel}
\alias{setMutationModel}
\title{Set a mutation model}
\usage{
setMutationModel(x, markers = NULL, model, ...)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{markers}{A vector of names or indices referring to markers attached to
\code{x}. (Default: All markers.)}

\item{model}{A model name implemented by \code{\link[pedmut:mutationModel]{pedmut::mutationModel()}}. See
Details.}

\item{...}{Arguments forwarded to \code{\link[pedmut:mutationModel]{pedmut::mutationModel()}}, e.g., \code{rate}.}
}
\value{
An object similar to \code{x}.
}
\description{
This function offers a convenient way to attach mutation models to a pedigree
with marker data. It wraps \code{\link[pedmut:mutationModel]{pedmut::mutationModel()}}, which does the main
work of creating the models, but relieves the user from having to loop
through the markers in order to supply the correct alleles and frequencies
for each marker.
}
\details{
Currently, the following models are implemented in the \code{pedmut} package:
\itemize{
\item \code{equal} :  All mutations equally likely; probability \eqn{1-rate} of no
mutation
\item \code{proportional} : Mutation probabilities are proportional to the target
allele frequencies
\item \code{onestep}: A mutation model for microsatellite markers, allowing mutations
only to the nearest neighbours in the allelic ladder. For example, '10' may
mutate to either '9' or '11', unless '10' is the lowest allele, in which case
'11' is the only option. This model is not applicable to loci with
non-integral microvariants.
\item \code{stepwise}: A common model in forensic genetics, allowing different
mutation rates between integer alleles (like '16') and non-integer
"microvariants" like '9.3'). Mutations also depend on the size of the
mutation if the parameter 'range' differs from 1.
\item \code{custom} : Allows any mutation matrix to be provided by the user, in the
\code{matrix} parameter
\item \code{random} : This produces a matrix of random numbers, where each row is
normalised so that it sums to 1
\item \code{trivial} : The identity matrix; i.e. no mutations are possible.
}
}
\examples{
### Example requires the pedmut package ###
if (requireNamespace("pedmut", quietly = TRUE)){

# A pedigree with data from a single marker
x = nuclearPed(1)
x = setMarkers(x, marker(x, geno = c("a/a", NA, "b/b"))) # mutation!

# Set `equal` model
x = setMutationModel(x, marker = 1, model = "equal", rate = 0.01)

# Inspect model
mutmod(x, 1)

# Likelihood
likelihood(x, 1)

}

}
