% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pq_plot.R
\name{pq_plot}
\alias{pq_plot}
\title{creating charts for time series}
\usage{
pq_plot(dt, chart_type = "line", freq = NULL, date_range = "max",
  from = NULL, to = Sys.Date(), x = "close|value", addti = list(volume
  = list()), linear_trend = NULL, perf = FALSE, yaxis_log = FALSE,
  color_up = "#CF002F", color_down = "#000000", multi_series = list(nrow
  = NULL, ncol = NULL), rm_weekend = NULL, title = NULL,
  interact = FALSE, ...)
}
\arguments{
\item{dt}{a list/dataframe of time series dataset}

\item{chart_type}{chart type, including line, step, bar, candle.}

\item{freq}{the frequency that the input daily data will converted to. It supports weekly, monthly, quarterly and yearly.}

\item{date_range}{date range. Available value includes '1m'-'11m', 'ytd', 'max' and '1y'-'ny'. Default is max.}

\item{from}{the start date. Default is NULL. If it is NULL, then calculate using date_range and end date.}

\item{to}{the end date. Default is the current date.}

\item{x}{the name of column display on chart.}

\item{addti}{list of technical indicators or numerical columns in dt. For technical indicator, it is calculated via \code{pq_addti}, which including overlay and oscillator indicators.}

\item{linear_trend}{a numeric vector. Default is NULL. If it is not NULL, then display linear trend lines on charts.}

\item{perf}{logical, display the performance of input series. Default is FALSE. If it is TRUE, then call \code{pq_code} to convert data into performance trends.}

\item{yaxis_log}{logical. Default is FALSE.}

\item{color_up}{the color indicates price going up}

\item{color_down}{the color indicates price going down}

\item{multi_series}{a list. It display the number of ncol or nrow, and the yaxis scales in 'free'/'free_y'/'free_x'. Default is NULL.}

\item{rm_weekend}{whether to remove weekends in xaxis. The default is TRUE for candle and bar chart, and is FALSE for line and step chart.}

\item{title}{chart title. It will added to the front of chart title if it is specified.}

\item{interact}{whether to create a interactive graphics, defaults to FALSE.}

\item{...}{ignored}
}
\description{
\code{pq_plot} provides an easy way to create charts for time series dataset based on predefined formats.
}
\examples{
\donttest{
# single symbol
ssec = md_stock('^000001', source='163', date_range = 'max')

# chart type
  pq_plot(ssec, chart_type = 'line',   date_range = '6m') # line chart (default)
# pq_plot(ssec, chart_type = 'step',   date_range = '6m') # step line
# pq_plot(ssec, chart_type = 'candle', date_range = '6m') # candlestick
# pq_plot(ssec, chart_type = 'bar',    date_range = '6m') # bar chart

# add technical indicators
pq_plot(ssec, chart_type = 'line', addti = list(
        sma = list(n = 200), 
        sma = list(n = 50), 
        macd = list()
))
# linear trend with yaxis in log
pq_plot(ssec, chart_type = 'line', linear_trend = c(-0.8, 0, 0.8), yaxis_log = TRUE)


# multiple symbols
# download datasets
# dat = md_stock(c('FB', 'AMZN', 'AAPL', 'NFLX', 'GOOG'), date_range = 'max')
dat = md_stock(c('^000001', '^399001', '^399006', '^000016', '^000300', '^000905'), 
               date_range = 'max', source='163')

# linear trend
pq_plot(dat, multi_series=list(nrow=2, scales='free_y'), linear_trend=c(-0.8, 0, 0.8))
pq_plot(dat, multi_series=list(nrow=2, scales='free_y'), linear_trend=c(-0.8, 0, 0.8), 
        yaxis_log=TRUE)

# performance
pq_plot(dat, multi_series = list(nrow=2), perf=TRUE, date_range = 'ytd')
pq_plot(dat, multi_series = list(nrow=1, ncol=1), perf=TRUE, date_range = 'ytd')

}

}
