% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalized.clr.R
\name{penalized.clr}
\alias{penalized.clr}
\title{Penalized conditional logistic regression}
\usage{
penalized.clr(
  response,
  stratum,
  penalized,
  unpenalized = NULL,
  lambda = NULL,
  alpha = 1,
  p = NULL,
  standardize = FALSE,
  event
)
}
\arguments{
\item{response}{The response variable, either a 0/1 vector or a factor with two levels.}

\item{stratum}{A numeric vector with stratum membership of each observation.}

\item{penalized}{A matrix of penalized covariates.}

\item{unpenalized}{A matrix of additional unpenalized covariates.}

\item{lambda}{The tuning parameter for L1. Either a single non-negative number,
or a numeric vector of the length equal to the number of blocks. If NULL, function \code{find.default.lambda} is called.  See p below.}

\item{alpha}{The elastic net mixing parameter, a number between 0 and 1.
alpha=0 would give pure ridge; alpha=1 gives lasso. Pure ridge penalty is never obtained in this implementation since alpha must be positive.}

\item{p}{The sizes of blocks of covariates,
a numerical vector of the length equal to the number of blocks,
and with the sum equal to the number of penalized covariates.
If missing, all covariates are treated the same and a single penalty is applied.}

\item{standardize}{Should the covariates be standardized, a logical value.}

\item{event}{If response is a factor, the level that
should be considered a success in the logistic regression.}
}
\value{
A list with the following elements:
\itemize{
\item \code{penalized} - Regression coefficients for the penalized covariates.
\item \code{unpenalized} - Regression coefficients for the unpenalized covariates.
\item \code{converged} - Whether the fitting process was judged to be converged.
\item \code{lambda} - The tuning parameter for L1 used.
\item \code{alpha} - The elastic net mixing parameter used.
}
}
\description{
Fits conditional logistic regression models with L1 and L2 penalty allowing
for different penalties for different blocks of covariates.
}
\details{
The \code{penalized.clr} function fits a conditional logistic regression
model for a given combination of L1 (\code{lambda}) and L2 penalties. L2 penalty is
obtained from \code{lambda} and \code{alpha} as \code{lambda*(1-alpha)/(2*alpha)}.
Note that \code{lambda} is a single number if all covariates are to be penalized
equally, and a vector of penatlies, if predictors are divided in blocks (of sizes provided in
\code{p}) that are to be penalized differently.  If \code{lambda} is not provided by the user,
a default value is computed by the \code{find.default.lambda}
function (which slows down the computation). The \code{penalized.clr} function
is based on the Cox model routine available in the
\code{penalized} package.
}
\examples{
set.seed(123)
# simulate covariates (pure noise in two blocks of 20 and 80 variables)
X <- cbind(matrix(rnorm(4000, 0, 1), ncol = 20), matrix(rnorm(16000, 2, 0.6), ncol = 80))

# stratum membership
stratum <- sort(rep(1:100, 2))

# the response
Y <- rep(c(1, 0), 100)

fit <- penalized.clr( response = Y, stratum = stratum,
  penalized = X, lambda = c(1, 0.3),
  p = c(20, 80), standardize = TRUE)
fit$penalized
fit$converged
fit$lambda
}
\seealso{
\code{\link{stable.clr}} and \code{\link{stable.clr.g}} for variable selection through stability selection
in penalized conditional logistic regression with a single penalty factor and multiple penalty factors, respectively.
}
