% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{hdfeppml}
\alias{hdfeppml}
\title{PPML Estimation with HDFE}
\usage{
hdfeppml(
  data,
  dep = 1,
  indep = NULL,
  fixed = NULL,
  cluster = NULL,
  selectobs = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing all relevant variables.}

\item{dep}{A string with the name of the independent variable or a column number.}

\item{indep}{A vector with the names or column numbers of the regressors. If left unspecified,
all remaining variables (excluding fixed effects) are included in the regressor matrix.}

\item{fixed}{A vector with the names or column numbers of factor variables identifying the fixed effects,
or a list with the desired interactions between variables in \code{data}.}

\item{cluster}{Optional. A string with the name of the clustering variable or a column number.
It's also possible to input a vector with several variables, in which case the interaction of
all of them is taken as the clustering variable.}

\item{selectobs}{Optional. A vector indicating which observations to use (either a logical vector
or a numeric vector with row numbers, as usual when subsetting in R).}

\item{...}{Further options. For a full list, see \link{hdfeppml_int}.}
}
\value{
A list with the following elements:
\itemize{
\item \code{coefficients}: a 1 x \code{ncol(x)} matrix with coefficient (beta) estimates.
\item \code{residuals}: a 1 x \code{length(y)} matrix with the residuals of the model.
\item \code{mu}: a 1 x \code{length(y)} matrix with the final values of the conditional mean \eqn{\mu}.
\item \code{deviance}:
\item \code{bic}: Bayesian Information Criterion.
\item \code{x_resid}: matrix of demeaned regressors.
\item \code{z_resid}: vector of demeaned (transformed) dependent variable.
\item \code{se}: standard errors of the coefficients.
}
}
\description{
\code{hdfeppml} fits an (unpenalized) Poisson Pseudo Maximum Likelihood (PPML) model with
high-dimensional fixed effects (HDFE).
}
\details{
This function is a thin wrapper around \link{hdfeppml_int}, providing a more convenient interface for
data frames. Whereas the internal function requires some preliminary handling of data sets (\code{y}
must be a vector, \code{x} must be a matrix and fixed effects \code{fes} must be provided in a list),
the wrapper takes a full data frame in the \code{data} argument, and users can simply specify which
variables correspond to y, x and the fixed effects, using either variable names or column numbers.

More formally, \code{hdfeppml_int} performs iteratively re-weighted least squares (IRLS) on a
transformed model, as described in Correia, Guimarães and Zylkin (2020) and similar to the
\code{ppmlhdfe} package in Stata. In each iteration, the function calculates the transformed dependent
variable, partials out the fixed effects (calling \code{collapse:fhdwithin}) and then solves a weighted
least squares problem (using fast C++ implementation).
}
\section{References}{

Breinlich, H., Corradi, V., Rocha, N., Ruta, M., Santos Silva, J.M.C. and T. Zylkin (2021).
"Machine Learning in International Trade Research: Evaluating the Impact of Trade Agreements",
Policy Research Working Paper; No. 9629. World Bank, Washington, DC.

Correia, S., P. Guimaraes and T. Zylkin (2020). "Fast Poisson estimation with high dimensional
fixed effects", \emph{STATA Journal}, 20, 90-115.

Gaure, S (2013). "OLS with multiple high dimensional category variables",
\emph{Computational Statistics & Data Analysis}, 66, 8-18.

Friedman, J., T. Hastie, and R. Tibshirani (2010). "Regularization paths for generalized linear
models via coordinate descent", \emph{Journal of Statistical Software}, 33, 1-22.

Belloni, A., V. Chernozhukov, C. Hansen and D. Kozbur (2016). "Inference in high dimensional panel
models with an application to gun control", \emph{Journal of Business & Economic Statistics}, 34, 590-605.
}

\examples{
\dontrun{
# To reduce run time, we keep only countries in the Americas:
americas <- countries$iso[countries$region == "Americas"]
test <- hdfeppml(data = trade[, -(5:6)],
                   dep = "export",
                   fixed = list(c("exp", "time"),
                                c("imp", "time"),
                                c("exp", "imp")),
                   selectobs = (trade$imp \%in\% americas) & (trade$exp \%in\% americas))
}

}
