% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perc_diff.R
\name{perc_diff}
\alias{perc_diff}
\title{Calculate percentile differences from an ordered categorical variable
 and a continuous variable.}
\usage{
perc_diff(data_model, categorical_var, continuous_var, weights = NULL,
  percentiles = c(90, 10))
}
\arguments{
\item{data_model}{A data frame with at least the categorical and continuous
variables from which to estimate the percentile differences}

\item{categorical_var}{The bare unquoted name of the categorical variable.
This variable SHOULD be an ordered factor. If not, the function will stop.}

\item{continuous_var}{The bare unquoted name of the continuous variable from
which to estimate the percentiles}

\item{weights}{The bare unquoted name of the optional weight variable.
If not specified, then estimation is done without weights}

\item{percentiles}{A numeric vector of two numbers specifying which
percentiles to subtract}
}
\value{
A vector with the percentile difference and it's associated
 standard error
}
\description{
Calculate percentile differences from an ordered categorical variable
 and a continuous variable.
}
\examples{

library(dplyr)

set.seed(23131)
N <- 1000
K <- 20

toy_data <- tibble::tibble(id = 1:N,
score = rnorm(N, sd = 2),
type = rep(paste0("inc", 1:20), each = N/K),
wt = 1)

# perc_diff(toy_data, type, score)
# type is not an ordered factor!

toy_data <-
toy_data \%>\%
mutate(type = factor(type, levels = unique(type), ordered = TRUE))


perc_diff(toy_data, type, score, percentiles = c(90, 10))
perc_diff(toy_data, type, score, percentiles = c(50, 10))

perc_diff(toy_data, type, score, weights = wt, percentiles = c(30, 10))
}
