% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_dend_utility_functions.R
\name{newNode}
\alias{newNode}
\title{Create a list of child nodes}
\usage{
newNode(hapmat, child1 = NULL, child0 = NULL, depth = 0)
}
\arguments{
\item{hapmat}{The hapMat object with columns ordered by ancestry.}

\item{child1}{The child node from splitting on the mutant allele at the next SNV in the ordered
neighborhood.}

\item{child0}{The child node from splitting on the non-mutant allele at the next SNV in the ordered
neighborhood.}
}
\description{
This function creates a pair of child nodes for a parent node.
}
\examples{

\dontshow{
 
data(ex_hapMatSmall_data)  

# First, select a window of SNVs about a focal SNV.
SNV_win <- selectWindow(hapMat = ex_hapMatSmall_data,
                        focalSNV = 10, minWindow = 1)
                        
# Then order SNVs in the window.
ordHapmat <- orderSNVs(snvWin = SNV_win)

# Create a list of child nodes.
chldNodes <- newNode(hapmat = ordHapmat)

}

}
\seealso{
\code{\link{makePartition}}
}
\keyword{internal}
