## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)
library("permutations")
set.seed(0)

## ----out.width='20%', out.extra='style="float:right; padding:10px"',echo=FALSE----
knitr::include_graphics(system.file("help/figures/permutations.png", package = "permutations"))

## -----------------------------------------------------------------------------
list(c(1, 3, 4), c(8, 9), c(2, 5))

## -----------------------------------------------------------------------------
cyclist_valid(list(c(1, -3, 4), c(8, 9), c(2, 5)))
cyclist_valid(list(c(0, 3, 4), c(8, 9), c(2, 5)))
cyclist_valid(list(c(1.2, 3, 4), c(8, 9), c(2, 5)))
cyclist_valid(list(c(3, 3, 4), c(8, 9), c(2, 5)))
cyclist_valid(list(c(1, 3, 4), c(1, 9), c(2, 5)))

## -----------------------------------------------------------------------------
a <- list(c(9, 3, 4), c(8, 1), c(2, 5))
a
nicify_cyclist(a)

## -----------------------------------------------------------------------------
a <- list(c(9, 3, 4), 7, c(8, 1), c(2, 5))
a
nicify_cyclist(a)

## -----------------------------------------------------------------------------
v <- c(1, 2, 4, 3, 5, 9, 6, 7, 8)
v
as.word(v)
vec2cyclist_single(v)

## -----------------------------------------------------------------------------
cyclist2word_single(list(c(1, 3, 4), c(8, 7, 9)))

## -----------------------------------------------------------------------------
char2cyclist_single("(3)(139)")
char2cyclist_single("(342)(19)")

## -----------------------------------------------------------------------------
(a <- list(list(c(1, 2, 4), c(3, 6)), list(c(1, 2), c(3, 4, 5, 6, 7))))
cycle(a)

## -----------------------------------------------------------------------------
as.cycle(c("(124)(36)", "(12)(34567)"))

