% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perumammals_api.R
\name{is_peru_mammal}
\alias{is_peru_mammal}
\title{Check if species are Peru mammals}
\usage{
is_peru_mammal(
  splist,
  return_details = FALSE,
  match_type = "status",
  filter_exact = FALSE
)
}
\arguments{
\item{splist}{Character vector of species names to check}

\item{return_details}{Logical. If TRUE, returns full validation tibble.
If FALSE, returns simplified status vector (default: FALSE)}

\item{match_type}{Character. Type of information to return when return_details = FALSE:
\itemize{
\item "status": Returns "Found" or "Not found" (default)
\item "match_quality": Returns match quality ("Exact", "Fuzzy", or "Not found")
\item "endemic": Returns endemism status ("Endemic", "Not endemic", or "Not found")
}}

\item{filter_exact}{Logical. If TRUE, only returns exact matches (genus_dist = 0
AND species_dist = 0). Fuzzy matches are treated as "Not found" (default: FALSE)}
}
\value{
If return_details = FALSE: Character vector with requested information.
If return_details = TRUE: Tibble with complete validation information.
}
\description{
Main wrapper function that validates species names against the Peru mammals
database with various output options for match quality, endemism status,
and detailed information.
}
\details{
This function wraps \code{validate_peru_mammals()} to provide flexible output
formats for different use cases:
\itemize{
\item Basic presence/absence checking
\item Match quality assessment (exact vs fuzzy)
\item Endemism status queries
}

The function handles taxonomic matching with fuzzy string matching to
accommodate minor spelling variations while maintaining data quality.

When filter_exact = TRUE, only matches with zero edit distance in both
genus and species names are considered valid matches. All fields related
to fuzzy matches are set to NA or "---" to maintain consistency.
}
\examples{

species <- c(
  "Panthera onca",       # Exact match
  "Pantera onca",        # Fuzzy match (genus misspelled)
  "Tremarctos orrnatus", # Fuzzy match (species misspelled)
  "Felis domesticus",     # Not in Peru
  "Myotis bakeri"
)

# Check if species are found (includes fuzzy matches)
is_peru_mammal(species)

# Check with exact matches only
is_peru_mammal(species, filter_exact = TRUE)

# Check match quality
is_peru_mammal(species, match_type = "match_quality")

# Check endemism
is_peru_mammal(species, match_type = "endemic")

# Get detailed information
is_peru_mammal(species, return_details = TRUE)

# Get detailed information with exact matches only
is_peru_mammal(species, return_details = TRUE, filter_exact = TRUE)


}
