% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{flamelet.clean}
\alias{flamelet.clean}
\title{Clean Persistence Flamelet}
\usage{
flamelet.clean(flamelet, band)
}
\arguments{
\item{flamelet}{a kxm matrix corresponding to the Persistence Flamelet.}

\item{band}{a scalar representing the confidence band.}
}
\value{
the value of the bandwidth corresponding to the most persistent feature of the Flamelet.
}
\description{
Remove all the values of the Persistence Flamelet which are not significantly different than 0
}
\examples{
\donttest{
library(TDA)
xx = rbind(circleUnif(50, 1), circleUnif(50, 1.5) + 3)
Xlim = c(-1, 5);  Ylim = c(-1, 5);  by = 0.05
lim = cbind(Xlim, Ylim)
foo.flamelet = build.flamelet(X = xx, h.grid = seq(0.01, 1, length.out = 40),
base.type = "landscape", dimension = 1,base.param = 1, lim = lim, by = by,
                            tseq = seq(0, .75, length.out = 500))
foo.band = flamelet.band(X = xx, B = 10, alpha = 0.95,
                   tseq = seq(0, .75, length.out = 500), diag.fun = kde,
                   h.grid = seq(0.01, 1, length.out = 40), lim = lim, by = by)
new.flamelet = flamelet.clean(foo.flamelet, foo.band)

}
}
\references{
T. Padellini and P. Brutti (2017) Persistence Flamelets: multiscale Persistent Homology for kernel density exploration \url{https://arxiv.org/abs/1709.07097}
}
