% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools.R
\name{dropFUNCTION}
\alias{dropFUNCTION}
\title{Generate a PostgreSQL DROP FUNCTION statement, optionally execute the statement if con is not NULL.}
\usage{
dropFUNCTION(
  name,
  args = NULL,
  if_exists = FALSE,
  cascade = FALSE,
  restrict = FALSE,
  con = NULL
)
}
\arguments{
\item{name}{A string, the "name" parameter for PostgreSQL DROP FUNCTION.}

\item{args}{A named list, names are the argument names, values are strings with the argument data types.}

\item{if_exists}{TRUE/FALSE, if TRUE, adds "IF EXISTS" to PostgreSQL DROP FUNCTION statement.}

\item{cascade}{TRUE/FALSE, if TRUE, adds "CASCADE" to PostgreSQL DROP FUNCTION statement.}

\item{restrict}{TRUE/FALSE, if TRUE, adds "RESTRICT" to PostgreSQL DROP FUNCTION statement.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, PostgreSQL DROP FUNCTION statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a PostgreSQL DROP FUNCTION statement, optionally execute the statement if con is not NULL.
}
\examples{
dropFUNCTION(
name = "sample",
args = list(a = "INTEGER", b = "TEXT")
)
}
