/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.functions;

import java.util.ArrayList;
import java.util.List;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.functions.PSFunction;

public class StitchingFunction
extends PSFunction {
    private List<PSFunction> functions = new ArrayList<PSFunction>();
    private int k;
    private double[] bounds;
    private double[] encode;

    public StitchingFunction(PSObjectDict pSObjectDict) throws PSError {
        this.loadCommonEntries(pSObjectDict);
        PSObjectArray pSObjectArray = pSObjectDict.get("Functions").toArray();
        this.k = pSObjectArray.size();
        for (int i = 0; i < this.k; ++i) {
            PSObject pSObject = pSObjectArray.get(i);
            if (!(pSObject instanceof PSObjectDict)) {
                throw new PSErrorTypeCheck();
            }
            PSFunction pSFunction = PSFunction.newFunction((PSObjectDict)pSObject);
            this.functions.add(pSFunction);
        }
        this.bounds = pSObjectDict.get("Bounds").toArray().toDoubleArray(this.k - 1);
        this.encode = pSObjectDict.get("Encode").toArray().toDoubleArray(2 * this.k);
    }

    public double[] evaluate(double[] dArray) throws PSErrorRangeCheck, PSErrorUnimplemented {
        double d;
        double d2;
        double[] dArray2 = this.evaluatePreProcess(dArray);
        double d3 = dArray2[0];
        int n = -1;
        for (int i = 0; i < this.k - 1; ++i) {
            if (!(d3 < this.bounds[i])) continue;
            n = i;
            break;
        }
        if (n < 0) {
            n = this.k - 1;
        }
        if (n == 0) {
            d2 = this.getDomain(0);
            d = this.k > 1 ? this.bounds[0] : this.getDomain(1);
        } else if (n == this.k - 1) {
            d2 = this.bounds[this.k - 2];
            d = this.getDomain(1);
        } else {
            d2 = this.bounds[n - 1];
            d = this.bounds[n];
        }
        double d4 = this.encode[2 * n];
        double d5 = this.encode[2 * n + 1];
        d3 = (d3 - d2) / (d - d2) * (d5 - d4) + d4;
        double[] dArray3 = new double[]{d3};
        double[] dArray4 = this.functions.get(n).evaluate(dArray3);
        return this.evaluatePostProcess(dArray4);
    }
}

