% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguFile.R
\name{pgu.file}
\alias{pgu.file}
\title{pgu.fie}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Handles file names for the pguIMP shiny web interface.
}
\details{
The class stores filenames and upload specifications for the pguIMP shiny web interface in its instance variables.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{uploadFileName}}{Returns the instance variable uploadFileName
(character)}

\item{\code{fileName}}{Returns the instance variable fileName
(character)}

\item{\code{baseName}}{Returns the instance variable baseName
(character)}

\item{\code{folderName}}{Returns the instance variable folderName
(character)}

\item{\code{suffix}}{Returns the instance variable suffix
(character)}

\item{\code{exportSuffix}}{Returns the instance variable exportSuffix
(character)}

\item{\code{timeString}}{Returns the instance variable timeString
(character)}

\item{\code{sheetIndex}}{Returns the instance variable sheetIndex
(numeric)}

\item{\code{separator}}{Returns the instance variable separator
(character)}

\item{\code{skipRows}}{Returns the instance variable skipRows
(numeric)}

\item{\code{columnNames}}{Returns the instance variable columnNames
(logical)}

\item{\code{naChar}}{Returns the instance variable naChar
(character)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.file$new()}}
\item \href{#method-print}{\code{pgu.file$print()}}
\item \href{#method-reset}{\code{pgu.file$reset()}}
\item \href{#method-fit}{\code{pgu.file$fit()}}
\item \href{#method-predict}{\code{pgu.file$predict()}}
\item \href{#method-fit_predict}{\code{pgu.file$fit_predict()}}
\item \href{#method-clone}{\code{pgu.file$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Clears the heap and
indicates that instance of \code{pgu.file} is removed from heap.


Splits fileName and writes the results in the class' instance variables
folderName, baseName, suffix.


Stores the current system time into the instance variable timeString.


Creates and returns a new object of type pgu.file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.file$new(
  uploadFileName = "",
  fileName = "",
  sheetIndex = 1,
  separator = ",",
  skipRows = 0,
  columnNames = TRUE,
  naChar = "NA"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uploadFileName}}{Name of uploaded file.
(string)}

\item{\code{fileName}}{Actual file name.
(string)}

\item{\code{sheetIndex}}{Index excel sheet to import.
(integer)}

\item{\code{separator}}{Character for column separation.
(character)}

\item{\code{skipRows}}{Number of rows to skip.
(integer)}

\item{\code{columnNames}}{Indicates if the data source file has a columnNames.
(logical)}

\item{\code{naChar}}{Character for missing values.
(string)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new pgu.file object.
(pguIMP::pgu.file)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints the instance variables of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.file$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the instance variables of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.file$reset(
  uploadFileName = "",
  fileName = "",
  sheetIndex = 1,
  separator = ",",
  skipRows = 0,
  columnNames = TRUE,
  naChar = "NA"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uploadFileName}}{Name of uploaded file.
(string)}

\item{\code{fileName}}{Actual file name.
(string)}

\item{\code{sheetIndex}}{Index excel sheet to import.
(integer)}

\item{\code{separator}}{Character for column separation.
(character)}

\item{\code{skipRows}}{Number of rows to skip.
(integer)}

\item{\code{columnNames}}{Indicates if the data source file has a columnNames.
(logical)}

\item{\code{naChar}}{Character for missing values.
(string)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Extracts information about upload specifications from the instance variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.file$fit()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
Predicts an export file name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.file$predict(affix = "analysis")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{affix}}{User dedined file name affix.
(string)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A file name.
(string)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit_predict"></a>}}
\if{latex}{\out{\hypertarget{method-fit_predict}{}}}
\subsection{Method \code{fit_predict()}}{
Extracts information about upload specifications from the instance variables
and predicts an export file name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.file$fit_predict(affix = "analysis")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{affix}}{User dedined file name affix.
(string)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A file name.
(string)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.file$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
