% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchfun_UIT.R
\name{UIT.design}
\alias{UIT.design}
\title{The design function for multinomial designs under union-intersection test (UIT)}
\usage{
UIT.design(method, s1.rej, t1.rej, s1.acc, t1.acc, n1, s2.rej, t2.rej, n2,
s1.rej.delta=0, t1.rej.delta=0, s1.acc.delta=0, t1.acc.delta=0,
s2.rej.delta=0, t2.rej.delta=0, n1.delta=0, n2.delta=0, p0.s, p0.t, p1.s, p1.t,
signif.level = 0.05, power.level = 0.85, output.all = FALSE, show.time = TRUE)
}
\arguments{
\item{method}{design methods according to number of stage and stopping rule, "s1" represents single-stage design stopping for both efficacy and futility, "s2" represents two-stage design stopping for both efficacy and futility, "s2.f" represents two-stage design stopping for futility only.}

\item{s1.rej}{first stage responses threshold to stop the trial for efficacy. Applied for "s1" or "s2".}

\item{t1.rej}{first stage disease progressions threshold to stop the trial for efficacy. Applied for "s1" or "s2".}

\item{s1.acc}{first stage responses threshold to stop the trial for futility. Applied for "s2" or "s2.f".}

\item{t1.acc}{first stage disease progressions threshold to stop the trial for futility. Applied for "s2" or "s2.f".}

\item{n1}{first stage sample size. Applied for "s1", "s2" or "s2.f".}

\item{s2.rej}{second stage responses threshold to stop the trial for efficacy. Applied for "s2" or "s2.f".}

\item{t2.rej}{second stage disease progressions threshold to stop the trial for efficacy. Applied for "s2" or "s2.f".}

\item{n2}{second stage sample size. Applied for "s2" or "s2.f".}

\item{s1.rej.delta}{pre-specified search difference for s1.rej.}

\item{t1.rej.delta}{pre-specified search difference for t1.rej.}

\item{s1.acc.delta}{pre-specified search difference for s1.acc.}

\item{t1.acc.delta}{pre-specified search difference for t1.acc.}

\item{s2.rej.delta}{pre-specified search difference for s2.rej.}

\item{t2.rej.delta}{pre-specified search difference for t2.rej.}

\item{n1.delta}{pre-specified search difference for n1.}

\item{n2.delta}{pre-specified search difference for n2.}

\item{p0.s}{pre-specified response rate under null hypothesis.}

\item{p0.t}{pre-specified disease progression rate under null hypothesis.}

\item{p1.s}{pre-specified response rate under alternative hypothesis.}

\item{p1.t}{pre-specified disease progression rate under alternative hypothesis.
Note: type I error calculation needs to take maximum of the power function with \eqn{(p.s,p.t)=(p_{01},0)} and \eqn{(p.s,p.t)=(1-p_{02},p_{02})}}

\item{signif.level}{pre-specified significant level.}

\item{power.level}{pre-specified power level.}

\item{output.all}{logical; if TRUE, output all possible designs satisfying type I error and power restrictions, otherwise, only output the design with maximum power .}

\item{show.time}{logical; if TRUE (default), show the calculation time for the search function.}
}
\value{
\item{boundset}{the boundaries set satisfying the design types properties: \eqn{s.rej}, \eqn{t.rej} and \eqn{N} for "s1",
 \eqn{s1.rej}, \eqn{t1.rej},  \eqn{s1.acc}, \eqn{t1.acc} and  \eqn{N1} for first stage and \eqn{s2.rej}, \eqn{t2.rej} and \eqn{N2} for the second stage of "s2",
 \eqn{s1.acc}, \eqn{t1.acc} and  \eqn{N1} for first stage and \eqn{s2.rej}, \eqn{t2.rej} and \eqn{N2} for the second stage of "s2.f",
 }
}
\description{
Search the type I error or power of a multinomial (response and disease progression) single- or two-stage design under IUT:
\eqn{H_0: p_1 \le p_{01} \ AND  \ p_2 \ge p_{02} \ versus \ H_1: p_1 \ge p_{11} > p_{01} \ OR  \ p_2 \le p_{12} < p_{02}}
}
\examples{

## Calculate type I error for single-stage design
UIT.design(method="s1",s1.rej=18, t1.rej = 12, n1=80,
p0.s = 0.15, p0.t = 0.25, p1.s = 0.3, p1.t= 0.1)

## Designs for two-stage design, output PET and EN under null hypothesis
UIT.design(method="s2",s1.rej = 11, t1.rej = 4, s1.acc=8, t1.acc = 5, n1=40,
s2.rej=18, t2.rej = 11, n2=40, p0.s = 0.15, p0.t = 0.25, p1.s = 0.3, p1.t= 0.1, output.all=TRUE)

}
\references{
Zee, B., Melnychuk, D., Dancey, J., & Eisenhauer, E. (1999).
\emph{Multinomial phase II cancer trials incorporating response and early progression.}
\emph{Journal of biopharmaceutical statistics, } \strong{9(2),} 351-363.

Simon, R. (1989).
\emph{Optimal two-stage designs for phase II clinical trials.}
\emph{Controlled clinical trials} \strong{10(1)}, 1-10.
}

