% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitch.R, R/parsimony.R
\name{fitch}
\alias{fitch}
\alias{random.addition}
\alias{parsimony}
\alias{sankoff}
\alias{optim.parsimony}
\alias{pratchet}
\alias{acctran}
\title{Parsimony tree.}
\usage{
fitch(tree, data, site = "pscore")

random.addition(data, method = "fitch")

parsimony(tree, data, method = "fitch", ...)

sankoff(tree, data, cost = NULL, site = "pscore")

optim.parsimony(tree, data, method = "fitch", cost = NULL, trace = 1,
  rearrangements = "SPR", ...)

pratchet(data, start = NULL, method = "fitch", maxit = 1000,
  minit = 10, k = 10, trace = 1, all = FALSE,
  rearrangements = "SPR", perturbation = "ratchet", ...)

acctran(tree, data)
}
\arguments{
\item{tree}{tree to start the nni search from.}

\item{data}{A object of class phyDat containing sequences.}

\item{site}{return either 'pscore' or 'site' wise parsimony scores.}

\item{method}{one of 'fitch' or 'sankoff'.}

\item{...}{Further arguments passed to or from other methods (e.g.
model="sankoff" and cost matrix).}

\item{cost}{A cost matrix for the transitions between two states.}

\item{trace}{defines how much information is printed during optimisation.}

\item{rearrangements}{SPR or NNI rearrangements.}

\item{start}{a starting tree can be supplied.}

\item{maxit}{maximum number of iterations in the ratchet.}

\item{minit}{minimum number of iterations in the ratchet.}

\item{k}{number of rounds ratchet is stopped, when there is no improvement.}

\item{all}{return all equally good trees or just one of them.}

\item{perturbation}{whether to use "ratchet", "random_addition" or
"stochastic" (nni) for shuffling the tree.}
}
\value{
\code{parsimony} returns the maximum parsimony score (pscore).
\code{optim.parsimony} returns a tree after NNI rearrangements.
\code{pratchet} returns a tree or list of trees containing the best tree(s)
found during the search.  \code{acctran} returns a tree with edge length
according to the ACCTRAN criterion.
}
\description{
\code{parsimony} returns the parsimony score of a tree using either the
sankoff or the fitch algorithm. \code{optim.parsimony} tries to find the
maximum parsimony tree using either Nearest Neighbor Interchange (NNI)
rearrangements or sub tree pruning and regrafting (SPR). \code{pratchet}
implements the parsimony ratchet (Nixon, 1999) and is the preferred way to
search for the best tree.  \code{random.addition} can be used to produce
starting trees.
}
\details{
The "SPR" rearrangements are so far only available for the "fitch" method,
"sankoff" only uses "NNI". The "fitch" algorithm only works correct for
binary trees.
}
\examples{

set.seed(3)
data(Laurasiatherian)
dm <- dist.hamming(Laurasiatherian)
tree <- NJ(dm)
parsimony(tree, Laurasiatherian)
treeRA <- random.addition(Laurasiatherian)
treeNNI <- optim.parsimony(tree, Laurasiatherian)
treeRatchet <- pratchet(Laurasiatherian, start=tree, maxit=100,
                        minit=5, k=5, trace=0)
# assign edge length
treeRatchet <- acctran(treeRatchet, Laurasiatherian)

plot(midpoint(treeRatchet))
add.scale.bar(0,0, length=100)

parsimony(c(tree,treeNNI, treeRatchet), Laurasiatherian)

}
\references{
Felsenstein, J. (2004). \emph{Inferring Phylogenies}. Sinauer
Associates, Sunderland.

Nixon, K. (1999) The Parsimony Ratchet, a New Method for Rapid Parsimony
Analysis. \emph{Cladistics} \bold{15}, 407-414
}
\seealso{
\code{\link{bab}}, \code{\link{CI}}, \code{\link{RI}}, \code{\link{ancestral.pml}},
\code{\link{nni}}, \code{\link{NJ}}, \code{\link{pml}}, \code{\link{getClans}}
,\code{\link{ancestral.pars}}, \code{\link{bootstrap.pml}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
