% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.R
\name{lli}
\alias{lli}
\alias{edQt}
\alias{pml.free}
\alias{pml.init}
\alias{pml.fit}
\title{Internal maximum likelihood functions.}
\usage{
lli(data, tree = NULL, ...)

edQt(Q = c(1, 1, 1, 1, 1, 1), bf = c(0.25, 0.25, 0.25, 0.25))

pml.free()

pml.init(data, k = 1L)

pml.fit(tree, data, bf = rep(1/length(levels), length(levels)), shape = 1,
  k = 1, Q = rep(1, length(levels) * (length(levels) - 1)/2),
  levels = attr(data, "levels"), inv = 0, rate = 1, g = NULL,
  w = NULL, eig = NULL, INV = NULL, ll.0 = NULL, llMix = NULL,
  wMix = 0, ..., site = FALSE, Mkv = FALSE, site.rate = "gamma")
}
\arguments{
\item{data}{An alignment, object of class \code{phyDat}.}

\item{tree}{A phylogenetic \code{tree}, object of class \code{phylo}.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{Q}{A vector containing the lower triangular part of the rate matrix.}

\item{bf}{Base frequencies.}

\item{k}{Number of intervals of the discrete gamma distribution.}

\item{shape}{Shape parameter of the gamma distribution.}

\item{levels}{The alphabet used e.g. c("a", "c", "g", "t") for DNA}

\item{inv}{Proportion of invariable sites.}

\item{rate}{Rate.}

\item{g}{vector of quantiles (default is NULL)}

\item{w}{vector of probabilities (default is NULL)}

\item{eig}{Eigenvalue decomposition of Q}

\item{INV}{Sparse representation of invariant sites}

\item{ll.0}{default is NULL}

\item{llMix}{default is NULL}

\item{wMix}{default is NULL}

\item{site}{return the log-likelihood or vector of sitewise likelihood
values}

\item{Mkv}{indicate if Lewis' Mkv should be estimated.}

\item{site.rate}{Indicates what type of gamma distribution to use. Options
are "gamma" approach of Yang 1994 (default), "quadrature" after the Laguerre
quadrature approach of Felsenstein 2001 and "freerate" .}
}
\value{
\code{pml.fit} returns the log-likelihood.
}
\description{
These functions are internally used for the likelihood computations in
\code{pml} or \code{optim.pml}.
}
\details{
These functions are exported to be used in different packages so far only in
the package coalescentMCMC, but are not intended for end user. Most of the
functions call C code and are far less forgiving if the import is not what
they expect than \code{pml}.
}
\references{
Felsenstein, J. (1981) Evolutionary trees from DNA sequences: a
maximum likelihood approach. \emph{Journal of Molecular Evolution},
\bold{17}, 368--376.
}
\seealso{
\code{\link{pml}, \link{pmlPart}, \link{pmlMix}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
