% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{sample_individual_estimates}
\alias{sample_individual_estimates}
\title{sample_individual_estimates}
\usage{
sample_individual_estimates(
  model,
  parameters = NULL,
  samples_per_id = 100,
  rng = NULL
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{parameters}{(vector) A vector of a subset of individual parameters to sample. Default is NULL, which means all.}

\item{samples_per_id}{(integer) Number of samples per individual}

\item{rng}{(rng or integer) Random number generator or seed}
}
\value{
(data.frame) Pool of samples in a DataFrame
}
\description{
Sample individual estimates given their covariance.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
rng <- create_rng(23)
sample_individual_estimates(model, samples_per_id=2, rng=rng)
}
}
\seealso{
sample_parameters_from_covariance_matrix : Sample parameter vectors using the

uncertainty covariance matrix

sample_parameters_uniformly : Sample parameter vectors using uniform distribution
}
