% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{sample_parameters_uniformly}
\alias{sample_parameters_uniformly}
\title{sample_parameters_uniformly}
\usage{
sample_parameters_uniformly(
  model,
  fraction = 0.1,
  parameters = NULL,
  force_posdef_samples = NULL,
  n = 1,
  rng = NULL
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{fraction}{(numeric) Fraction of estimate value to use for distribution bounds}

\item{parameters}{(data.frame) Names of parameters to use. Default is to use all parameters in the model.}

\item{force_posdef_samples}{(integer) Number of samples to reject before forcing variability parameters to give
positive definite covariance matrices.}

\item{n}{(integer) Number of samples}

\item{rng}{(integer or rng) Random number generator or seed}
}
\value{
(data.frame) samples
}
\description{
Sample parameter vectors using uniform sampling

Each parameter value will be randomly sampled from a uniform distribution
with the bounds being estimate ± estimate * fraction.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
rng <- create_rng(23)
sample_parameters_uniformly(model, n=3, rng=rng)
}
}
\seealso{
sample_parameters_from_covariance_matrix : Sample parameter vectors using the

uncertainty covariance matrix

sample_individual_estimates : Sample individual estiates given their covariance
}
