% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{mu_reference_model}
\alias{mu_reference_model}
\title{mu_reference_model}
\usage{
mu_reference_model(model)
}
\arguments{
\item{model}{(Model) Pharmpy model object}
}
\value{
(Model) Reference to same object
}
\description{
Convert model to use mu-referencing

Mu-referencing an eta is to separately define its actual mu (mean) parameter.
For example: :math:\verb{CL = \\theta_1 e^\{\\eta_1\}} with :math:\verb{\\eta_1} following a zero-mean
normal distribution would give :math:\verb{\\mu_1 = log\{\\theta_1\}} and
:math:\verb{CL = e^\{\\mu_1 + \\eta_1\}}
}
\examples{
\dontrun{
model <- load_example_model("pheno")
mu_reference_model(model).statements$before_odes
}

}
