% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{summarize_individuals}
\alias{summarize_individuals}
\title{summarize_individuals}
\usage{
summarize_individuals(models)
}
\arguments{
\item{models}{(array(Model)) Input models}
}
\value{
(data.frame | NULL) The summary as a dataframe
}
\description{
Creates a summary dataframe keyed by model-individual pairs for an input
vector of models.

Content of the various columns:

+-------------------------+----------------------------------------------------------------------+
| Column                  | Description                                                          |
+=========================+======================================================================+
| \code{outlier_count}       | Number of observations with CWRES > 5                                |
+-------------------------+----------------------------------------------------------------------+
| \code{ofv}                 | Individual OFV                                                       |
+-------------------------+----------------------------------------------------------------------+
| \code{dofv_vs_parent}      | Difference in individual OFV between this model and its parent model |
+-------------------------+----------------------------------------------------------------------+
| \code{predicted_dofv}      | Predicted dOFV if this individual was excluded                       |
+-------------------------+----------------------------------------------------------------------+
| \code{predicted_residual}  | Predicted residual                                                   |
+-------------------------+----------------------------------------------------------------------+
}
\examples{
\dontrun{
model <- load_example_model("pheno")
fit_results <- fit(model)
results <- run_tool(
 model=model,
 mfl='ABSORPTION(ZO);PERIPHERALS(c(1, 2))',
 algorithm='reduced_stepwise'
summarize_individuals([results$start_model, *results$models])
}

}
