% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weib_percentile.R
\name{weib_percentile}
\alias{weib_percentile}
\title{Calculating a percentile estimate of a seasonal abundance distribution from
incidental observations.}
\usage{
weib_percentile(observations, percentile = 0.9, iterations = 500)
}
\arguments{
\item{observations}{is a vector of dates/time of observations
given as integers}

\item{percentile}{is the percentile of the cumulative distribution function
of interest}

\item{iterations}{is the number of iterations you want to use to bootstrap
an estimate of bias of the original CDF. The bias is used to calculate
a Weibull-corrected estimate of the percentile bound.}
}
\value{
The Weibull-corrected estimate of the percentile of interest.
}
\description{
\code{weib_percentile} uses empirical bootstrapping to estimate a percentile
of the Weibull distribution, given random variables.
}
\examples{
\donttest{
# Gather sightings of iNaturalist observations for four species:
# Danaus plexippus, Speyeria cybele, Rudbeckia hirta, and Asclepias syriaca

# Estimate when the first 50 percent of individuals of the milkweed species
# Asclepias syriaca have been observed.

data(inat_examples)
a_syriaca <- subset(inat_examples, scientific_name == "Asclepias syriaca")
weib_percentile(a_syriaca$doy, percentile = 0.5, iterations = 10)

# Estimate when 90 percent of individuals of the milkweed species A. syriaca
# have been observed, using only 100 iterations for quicker processing

weib_percentile(a_syriaca$doy, percentile = 0.5, iterations = 10)
}
}
\keyword{percentile}
\keyword{phenology}
\keyword{weibull}
