plotExplore <- function(x) {
    ## check errors
    classes <- lapply(x, class)
    error.pos <- which(classes=='try-error')
    if (length(error.pos)!=0) x[error.pos] <- 0
    ## build plot composition
    par(mfrow=c(5,5), oma=c(5,4,4,5), mar=rep(0,4),xaxt='n', yaxt='n')
    ## plot list elements
    plot(x[[1]], main='', pch=20, col='grey', type='p', what='fitting')
    axis(2)
    mtext('SPLINE', 2, line=2)
    mtext(round(x$rmses['spline'], 3), 3, line=-2.5, adj=0.1)
    plot(x$spline.trs, main='', pch=20, col='grey', type='p')
    mtext('TRS',3, 0.5)
    plot(x$spline.der, main='', pch=20, col='grey', type='p')
    mtext('DERIVATIVES',3, 0.5)
    plot(x$spline.klosterman, main='', pch=20, col='grey', type='p')
    mtext('KLOSTERMAN',3, 0.5)
    plot(x$spline.gu, main='', pch=20, col='grey', type='p')
    mtext('GU',3, 0.5)
    plot(x[[5]], main='', pch=20, col='grey', type='p', what='fitting')
    mtext(round(x$rmses['beck'], 3), 3, line=-2.5, adj=0.1)
    mtext('BECK', 2, line=2)
    plot(x$beck.trs, main='', pch=20, col='grey', type='p')
    plot(x$beck.der, main='', pch=20, col='grey', type='p')
    plot(x$beck.klosterman, main='', pch=20, col='grey', type='p')
    plot(x$beck.gu, main='', pch=20, col='grey', type='p')
    plot(x[[9]], main='', pch=20, col='grey', type='p', what='fitting')
    mtext(round(x$rmses['elmore'], 3), 3, line=-2.5, adj=0.1)
    mtext('ELMORE', 2, line=2)
    plot(x$elmore.trs, main='', pch=20, col='grey', type='p')
    plot(x$elmore.der, main='', pch=20, col='grey', type='p')
    plot(x$elmore.klosterman, main='', pch=20, col='grey', type='p')
    plot(x$elmore.gu, main='', pch=20, col='grey', type='p')
    plot(x[[13]], main='', pch=20, col='grey', type='p', what='fitting')
    mtext(round(x$rmses['klosterman'], 3), 3, line=-2.5, adj=0.1)
    mtext('KLOSTERMAN', 2, line=2)
    plot(x$klosterman.trs, main='', pch=20, col='grey', type='p')
    plot(x$klosterman.der, main='', pch=20, col='grey', type='p')
    plot(x$klosterman.klosterman, main='', pch=20, col='grey', type='p')
    plot(x$klosterman.gu, main='', pch=20, col='grey', type='p')
    plot(x[[17]], main='', pch=20, col='grey', type='p', what='fitting')
    mtext(round(x$rmses['gu'], 3), 3, line=-2.5, adj=0.1)
    mtext('GU', 2, line=2)
    plot(x$gu.trs, main='', pch=20, col='grey', type='p')
    plot(x$gu.der, main='', pch=20, col='grey', type='p')
    plot(x$gu.klosterman, main='', pch=20, col='grey', type='p')
    plot(x$gu.gu, main='', pch=20, col='grey', type='p')
    par(new=TRUE, mfrow=c(1,1), oma=rep(0,4))
    plot(0, type='n', axes=FALSE, ylab='', xlab='')
    xmean <- mean(par('usr')[1:2])
    mtext('DIFFERENT PHENOPHASE METHODS', 1, line=-2.2, font=2)
    arrows(xmean-0.3,-1.02,xmean+0.3,-1.02)
    arrows(1.37, -0.7, 1.37, 0.7)
    mtext('DIFFERENT FITTING METHODS', 4, line=-2, font=2)
    arrows(0.64, -0.95, 0.67, -0.65)
    mtext('RMSE', 1, line=-2.3, font=2, adj=0.05)
}
