% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phers.R
\name{getScores}
\alias{getScores}
\title{Calculate phenotype risk scores}
\usage{
getScores(demos, phecodeOccurrences, weights, diseasePhecodeMap)
}
\arguments{
\item{demos}{A data.table having one row per person in the cohort. Must have
a column \code{person_id}.}

\item{phecodeOccurrences}{A data.table of phecode occurrences for each person
in the cohort. Must have columns \code{person_id} and \code{phecode}.}

\item{weights}{A data.table of phecodes and their corresponding weights.
Must have columns \code{phecode} and \code{w}.}

\item{diseasePhecodeMap}{A data.table of the mapping between diseases and
phecodes. Must have columns \code{disease_id} and \code{phecode}.}
}
\value{
A data.table containing the phenotype risk score for each person for
each disease.
}
\description{
A person's phenotype risk score for a given disease corresponds to the
sum of the weights of the disease-relevant phecodes that the person has
received.
}
\examples{
library('data.table')

# map ICD codes to phecodes
phecodeOccurrences = getPhecodeOccurrences(icdSample)

# calculate weights
weights = getWeights(demoSample, phecodeOccurrences)

# OMIM disease IDs for which to calculate phenotype risk scores
diseaseId = 154700

# map diseases to phecodes
diseasePhecodeMap = mapDiseaseToPhecode()

# calculate scores
scores = getScores(
  demoSample, phecodeOccurrences, weights, diseasePhecodeMap[disease_id == diseaseId])

# calculate residual scores
rscores = getResidualScores(demoSample, scores, glmFormula = ~ sex)
}
\seealso{
\code{\link[=mapDiseaseToPhecode]{mapDiseaseToPhecode()}}, \code{\link[=getPhecodeOccurrences]{getPhecodeOccurrences()}}, \code{\link[=getWeights]{getWeights()}},
\code{\link[=getResidualScores]{getResidualScores()}}, \code{\link[=phers]{phers()}}
}
