% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{getWhatMeasured}
\alias{getWhatMeasured}
\alias{what_measured}
\alias{getWhatMeasured.default}
\alias{getWhatMeasured.generic_spct}
\alias{getWhatMeasured.summary_generic_spct}
\alias{getWhatMeasured.generic_mspct}
\title{Get the "what.measured" attribute}
\usage{
getWhatMeasured(x, ...)

what_measured(x, ...)

\method{getWhatMeasured}{default}(x, ...)

\method{getWhatMeasured}{generic_spct}(x, ...)

\method{getWhatMeasured}{summary_generic_spct}(x, ...)

\method{getWhatMeasured}{generic_mspct}(x, ..., idx = "spct.idx")
}
\arguments{
\item{x}{a generic_spct object}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
character vector An object containing a description of the data.
}
\description{
Function to read the "what.measured" attribute of an existing generic_spct
or a generic_mspct.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default

\item \code{generic_spct}: generic_spct

\item \code{summary_generic_spct}: summary_generic_spct

\item \code{generic_mspct}: generic_mspct
}}

\note{
The method for collections of spectra returns the
  a tibble with a column of character strings.
}
\examples{

what_measured(sun.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
