% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-oojaz-file.r
\name{read_oo_jazirrad}
\alias{read_oo_jazdata}
\alias{read_oo_jazirrad}
\title{Read Absolute Irradiance File Saved by Ocean Optics' Jaz spectrometer.}
\usage{
read_oo_jazirrad(file, date = NULL, geocode = NULL, label = NULL,
  tz = NULL, locale = readr::default_locale())

read_oo_jazdata(file, date = NULL, geocode = NULL, label = NULL,
  tz = NULL, locale = readr::default_locale())
}
\arguments{
\item{file}{character string.}

\item{date}{a \code{POSIXct} object, but if \code{NULL} the date stored in 
file header is used, and if \code{NA} the "when.measured" attribute is not
set.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone used for interpreting times saved in the file
header.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}
}
\value{
A source_spct object.

A raw_spct object.
}
\description{
Reads and parses the header of a processed data file as output by
Jaz instruments to extract the whole header remark field The time field is
retrieved.
}
\note{
Although the parameter is called \code{date} a date time is accepted 
  and expected. Time resolution is 1 s.
}
\references{
\url{http://www.r4photobiology.info}
}
\keyword{misc}

