#' Spectral data for LEDs array supplied by Shenzhen Weili Optical
#'
#' Datasets containing the wavelengths and tabulated values spectral emittance
#' for different light emitting diodes (LEDs) arrays from Shenzhen Weili Optical
#' Ltd.  Data are normalized to one at the wavelength of maximum emission.
#'
#' The variables are as follows:
#' \itemize{
#'   \item w.length (nm)
#'   \item s.e.irrad (W m-2 nm-1)
#' }
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @aliases shenzhen_weili
#' @examples
#' shenzhen_weili
#' leds_global
#' leds.mspct[leds_global]
#'
#' @note
#' Leds Global and Shenzhen Weili are trade names of the same supplier of LED
#' arrays. They sell both standard types and also assemble customized arrays
#' upon request. Customized arrays may have up to five independent channels.
#'
#' \url{http://www.leds-global.com/}
#'
"leds_global"
