% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cie.e.fun.r
\name{CIE_e_fun}
\alias{CIE_e_fun}
\title{Gives values for the erythemal BSWF as a function of wavelength}
\usage{
CIE_e_fun(w.length)
}
\arguments{
\item{w.length}{numeric array of wavelengths (nm)}
}
\value{
a numeric array of the same length as \code{w.length} with values for
  the BSWF normalized as in the original source (298 nm) and based on energy
  effectiveness.
}
\description{
This function gives a set of numeric multipliers that can be used
as a weight to calculate effective doses and irradiances. The
returned values are on quantum based effectiveness relative units.
}
\examples{
CIE_e_fun(293:400)

}
\seealso{
Other BSWF functions: \code{\link{CH4_e_fun}},
  \code{\link{CH4_q_fun}}, \code{\link{CIE_q_fun}},
  \code{\link{DNA_GM_q_fun}}, \code{\link{DNA_P_q_fun}},
  \code{\link{FLAV_q_fun}}, \code{\link{GEN_G_q_fun}},
  \code{\link{GEN_M_q_fun}}, \code{\link{GEN_T_q_fun}},
  \code{\link{ICNIRP_e_fun}}, \code{\link{PG_q_fun}}
}

