% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nConfig.R
\name{nConfig}
\alias{nConfig}
\title{Configuration sizes in a tree}
\usage{
nConfig(tree, maxClade = NULL)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{maxClade}{An integer between 1 and the number of tips (the default), specifying the maximum clade size of interest.}
}
\value{
A list with 2 entries: 
\itemize{
\item cladeSizes is a vector giving the size of the clade descending at each node. Tips all have the value 1. 
Internal nodes have their number of tip descendants. 
\item numClades is a vector where numClades[[i]] is the number of clades of size i in the tree. 
All clade sizes are calculated, but the output can be restricted using \code{maxClade} to just those of size up to 'maxClade'.
}
}
\description{
Finds the sizes of configurations in the tree.
}
\examples{
## Configuration sizes on a random tree with 10 tips:
tree <- rtree(10)
plot(tree)
nodelabels()
nConfig(tree)


}
\author{
Caroline Colijn \email{c.colijn@imperial.ac.uk}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}

