% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.pres.R
\name{tip.root.path}
\alias{tip.root.path}
\title{Compute tree edge lengths and node paths from root to each tip}
\usage{
tip.root.path(tree)
}
\arguments{
\item{tree}{phylo. A dated tree.}
}
\value{
returns a list with two components: matrix H1
representing the paths through the tree from root to each tip,
and edge.length a
numeric vector giving the length of each branch in the tree. Some matrix
algebra and a summation of the resulting vector gives the whole-tree
PD value.
}
\description{
Computation of tree edge lengths and node paths from root to each tip to
calculate PD for a entire phylogeny (= sum of all edge or branch lengths)
}
\details{
Based on the algorithm FastXtreePhylo of Peter D. Wilson
}
\examples{
library(phyloraster)
tree <- ape::read.tree(system.file("extdata", "tree.nex",
package="phyloraster"))

fxtp <- tip.root.path(tree)
H1 <- fxtp$H1
edge.length <- fxtp$edge.length
# PD for the whole community
pres <- rep(1, nrow(H1))
sum((crossprod(H1, pres)>0) * edge.length)

# PD for a random subset of the community
pres <- sample(c(1, 0), nrow(H1), TRUE)
sum((crossprod(H1, pres)>0) * edge.length)

}
\author{
Peter Wilson
}
